/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.search;

import com.google.gwt.eclipse.core.search.IIndexedJavaRef;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.validators.java.JsniJavaRef;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IMemento;

public class IndexedJsniJavaRef
extends JsniJavaRef
implements IIndexedJavaRef {
    private static final String TAG_OFFSET = "offset";
    private static final String TAG_SOURCE = "source";

    public static IndexedJsniJavaRef load(IMemento memento) {
        String refString = memento.getTextData();
        if (refString == null) {
            return null;
        }
        JsniJavaRef ref = JsniJavaRef.parse(refString);
        if (ref == null) {
            return null;
        }
        String sourceString = memento.getString(TAG_SOURCE);
        if (sourceString == null) {
            return null;
        }
        ref.setSource((IPath)new Path(sourceString));
        Integer offset = memento.getInteger(TAG_OFFSET);
        if (offset == null) {
            return null;
        }
        ref.setOffset(offset);
        return new IndexedJsniJavaRef(ref);
    }

    public IndexedJsniJavaRef(JsniJavaRef ref) {
        super(ref);
    }

    @Override
    public String memberSignature() {
        if (this.isConstructor()) {
            return String.valueOf(this.simpleClassName()) + "()";
        }
        return super.memberSignature();
    }

    @Override
    public String rawClassName() {
        return this.className();
    }

    @Override
    public IJavaElement resolve() {
        IJavaProject javaProject;
        block5: {
            IProject project;
            block4: {
                try {
                    project = Util.getProject(this.getSource());
                    if (project != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) break block5;
            return null;
        }
        return super.resolveJavaElement(javaProject);
    }

    @Override
    public void save(IMemento memento) {
        memento.putTextData(super.toString());
        memento.putString(TAG_SOURCE, this.getSource().toString());
        memento.putInteger(TAG_OFFSET, this.getOffset());
    }

    @Override
    public void setOffset(int offset) {
        throw new UnsupportedOperationException("Offset property is read-only");
    }

    @Override
    public void setSource(IPath source) {
        throw new UnsupportedOperationException("Source property is read-only");
    }

    public String toString() {
        String superString = super.toString();
        return MessageFormat.format("{0} @ {1} ({2}, {3})", superString, this.getSource().toString(), String.valueOf(this.getOffset()), String.valueOf(superString.length()));
    }
}

