/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.search;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.search.IIndexedJavaRef;
import com.google.gwt.eclipse.core.search.JavaRefIndex;
import com.google.gwt.eclipse.core.util.Util;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;

public class JavaQueryParticipant
implements IQueryParticipant {
    private static final IJavaSearchScope WORKSPACE_SCOPE = SearchEngine.createWorkspaceScope();

    public static Set<IIndexedJavaRef> findWorkspaceReferences(IJavaElement element, boolean resolveMatches) {
        JavaQueryParticipant searchEngine = new JavaQueryParticipant();
        ElementQuerySpecification query = new ElementQuerySpecification(element, 2, WORKSPACE_SCOPE, "");
        return searchEngine.findMatches(query, resolveMatches);
    }

    private static boolean isTypeSearch(QuerySpecification query) {
        if (query instanceof ElementQuerySpecification) {
            return ((ElementQuerySpecification)query).getElement().getElementType() == 7;
        }
        return ((PatternQuerySpecification)query).getSearchFor() == 0;
    }

    public int estimateTicks(QuerySpecification specification) {
        return 500;
    }

    public IMatchPresentation getUIParticipant() {
        return null;
    }

    public void search(ISearchRequestor requestor, QuerySpecification query, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.subTask("Locating GWT matches...");
            switch (query.getLimitTo()) {
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    return;
                }
            }
            Set<IIndexedJavaRef> matchingJavaRefs = null;
            if (query instanceof ElementQuerySpecification) {
                ElementQuerySpecification elementQuery = (ElementQuerySpecification)query;
                matchingJavaRefs = this.findMatches(elementQuery, true);
            } else {
                assert (query instanceof PatternQuerySpecification);
                PatternQuerySpecification patternQuery = (PatternQuerySpecification)query;
                matchingJavaRefs = this.findMatches(patternQuery);
            }
            for (IIndexedJavaRef javaRef : matchingJavaRefs) {
                Match match = this.createMatch(javaRef, query);
                if (match == null) continue;
                requestor.reportMatch(match);
            }
        }
        catch (Exception e) {
            GWTPluginLog.logError("Error finding Java Search matches", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Match createMatch(IIndexedJavaRef ref, QuerySpecification query) {
        int length;
        int offset;
        IPath filePath = ref.getSource();
        IFile file = Util.getWorkspaceRoot().getFile(filePath);
        if (!file.exists()) {
            return null;
        }
        if (JavaQueryParticipant.isTypeSearch(query)) {
            offset = ref.getClassOffset();
            length = ref.className().length();
            if (query instanceof ElementQuerySpecification) {
                IType type = (IType)((ElementQuerySpecification)query).getElement();
                length = type.getFullyQualifiedName().length();
            }
        } else {
            offset = ref.getMemberOffset();
            length = ref.memberName().length();
        }
        IFile container = file;
        try {
            ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IFile)file);
            if (cu == null) {
                if (query.getScope().encloses(filePath.toString())) return new Match((Object)container, offset, length);
                return null;
            }
            IJavaElement jsniMethod = cu.getElementAt(offset);
            assert (jsniMethod instanceof IMethod);
            if (!query.getScope().encloses(jsniMethod)) {
                return null;
            }
            container = jsniMethod;
            return new Match((Object)container, offset, length);
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
            return null;
        }
    }

    private Set<IIndexedJavaRef> findMatches(ElementQuerySpecification query, boolean resolveMatches) {
        Set<IIndexedJavaRef> nameMatches;
        IJavaElement javaElement = query.getElement();
        JavaRefIndex index = JavaRefIndex.getInstance();
        int elementType = javaElement.getElementType();
        if (elementType == 7) {
            String typeName = ((IType)javaElement).getFullyQualifiedName();
            return index.findTypeReferences(typeName);
        }
        if (elementType != 8 && elementType != 9) {
            return Collections.emptySet();
        }
        IType declType = ((IMember)javaElement).getDeclaringType();
        assert (declType != null && declType.exists());
        Set<IIndexedJavaRef> set = nameMatches = elementType == 9 ? index.findMethodReferences(javaElement.getElementName()) : index.findFieldReferences(javaElement.getElementName());
        if (!resolveMatches) {
            return nameMatches;
        }
        HashSet<IIndexedJavaRef> matches = new HashSet<IIndexedJavaRef>();
        for (IIndexedJavaRef nameMatch : nameMatches) {
            IJavaElement matchElement = nameMatch.resolve();
            if (!javaElement.equals(matchElement)) continue;
            matches.add(nameMatch);
        }
        return matches;
    }

    private Set<IIndexedJavaRef> findMatches(PatternQuerySpecification query) {
        int elementType;
        switch (query.getSearchFor()) {
            case 0: {
                elementType = 7;
                break;
            }
            case 4: {
                elementType = 8;
                break;
            }
            case 1: 
            case 3: {
                elementType = 9;
                break;
            }
            default: {
                return Collections.emptySet();
            }
        }
        return JavaRefIndex.getInstance().findElementReferences(query.getPattern(), elementType, query.isCaseSensitive());
    }
}

