/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.search;

import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.search.IIndexedJavaRef;
import com.google.gwt.eclipse.core.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public final class JavaRefIndex {
    private static JavaRefIndex INSTANCE;
    private static final String JAVA_REF_LOAD_METHOD = "load";
    private static final String MEMBER_KEY_PREFIX = "::";
    private static final String METHOD_KEY_SUFFIX = "()";
    private static final String SEARCH_INDEX_FILENAME = "searchIndex";
    private static final String TAG_JAVA_REF = "JavaRef";
    private static final String TAG_JAVA_REF_CLASS = "class";
    private static final String TAG_JAVA_REFS = "JavaRefs";
    private final Map<String, Set<IIndexedJavaRef>> elementIndex = new HashMap<String, Set<IIndexedJavaRef>>();
    private final Map<IPath, Set<IIndexedJavaRef>> fileIndex = new HashMap<IPath, Set<IIndexedJavaRef>>();

    public static JavaRefIndex getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JavaRefIndex();
        }
        return INSTANCE;
    }

    public static void save() {
        if (INSTANCE == null) {
            return;
        }
        INSTANCE.saveIndex();
    }

    private static String getElementMemberKey(String memberSignature) {
        int paren = memberSignature.indexOf(40);
        if (paren > -1) {
            memberSignature = String.valueOf(memberSignature.substring(0, paren)) + METHOD_KEY_SUFFIX;
        }
        return MEMBER_KEY_PREFIX + memberSignature;
    }

    private static File getIndexFile() {
        return GWTPlugin.getDefault().getStateLocation().append(SEARCH_INDEX_FILENAME).toFile();
    }

    private JavaRefIndex() {
        this.loadIndex();
    }

    public void add(IIndexedJavaRef ref) {
        this.addToElementIndex(ref);
        this.addToFileIndex(ref);
    }

    public void add(IPath file, Set<IIndexedJavaRef> refs) {
        this.clear(file);
        if (refs.size() > 0) {
            this.fileIndex.put(file, refs);
        }
        for (IIndexedJavaRef ref : refs) {
            this.addToElementIndex(ref);
        }
    }

    public void clear() {
        this.elementIndex.clear();
        this.fileIndex.clear();
    }

    public void clear(IPath file) {
        if (this.fileIndex.containsKey(file)) {
            Set<IIndexedJavaRef> fileRefs = this.fileIndex.get(file);
            for (IIndexedJavaRef fileRef : fileRefs) {
                this.removeRefsFromElementIndex(fileRef, file);
            }
            fileRefs.clear();
        }
    }

    public void clear(IProject project) {
        for (IPath file : this.fileIndex.keySet()) {
            if (!project.getName().equals(file.segment(0))) continue;
            this.clear(file);
        }
    }

    public Set<IIndexedJavaRef> findElementReferences(String pattern, int elementType, boolean caseSensitive) {
        boolean simpleTypeNameSearch = false;
        if (elementType == 7) {
            if (pattern.lastIndexOf(46) == -1) {
                simpleTypeNameSearch = true;
            }
        } else {
            int lastDot;
            if (elementType == 9) {
                int paren = pattern.indexOf(40);
                if (paren > -1) {
                    pattern = pattern.substring(0, paren);
                }
                pattern = String.valueOf(pattern) + METHOD_KEY_SUFFIX;
            }
            if ((lastDot = pattern.lastIndexOf(46)) > -1) {
                pattern = pattern.substring(lastDot + 1);
            }
            pattern = JavaRefIndex.getElementMemberKey(pattern);
        }
        if (caseSensitive && !simpleTypeNameSearch && pattern.indexOf(42) == -1 && pattern.indexOf(63) == -1) {
            return this.findElementReferences(pattern);
        }
        HashSet<IIndexedJavaRef> refs = new HashSet<IIndexedJavaRef>();
        Iterator<String> iterator = this.elementIndex.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String element = key = iterator.next();
            if (simpleTypeNameSearch) {
                element = Signature.getSimpleName((String)element);
            }
            char[] patternChars = pattern.toCharArray();
            if (!caseSensitive) {
                patternChars = CharOperation.toLowerCase((char[])patternChars);
            }
            if (!CharOperation.match((char[])patternChars, (char[])element.toCharArray(), (boolean)caseSensitive)) continue;
            refs.addAll((Collection<IIndexedJavaRef>)this.elementIndex.get(key));
        }
        return refs;
    }

    public Set<IIndexedJavaRef> findFieldReferences(String fieldName) {
        fieldName = MEMBER_KEY_PREFIX + fieldName;
        return this.findElementReferences(fieldName);
    }

    public Set<IIndexedJavaRef> findMethodReferences(String methodName) {
        methodName = MEMBER_KEY_PREFIX + methodName + METHOD_KEY_SUFFIX;
        return this.findElementReferences(methodName);
    }

    public Set<IIndexedJavaRef> findTypeReferences(String qualifiedTypeName) {
        Set<IIndexedJavaRef> refs = this.elementIndex.get(qualifiedTypeName = qualifiedTypeName.replace('$', '.'));
        if (refs != null) {
            HashSet<IIndexedJavaRef> copy = new HashSet<IIndexedJavaRef>();
            copy.addAll(refs);
            return copy;
        }
        return Collections.emptySet();
    }

    public int size() {
        int size = 0;
        for (Map.Entry<IPath, Set<IIndexedJavaRef>> fileIndexEntry : this.fileIndex.entrySet()) {
            String projectName = fileIndexEntry.getKey().segment(0);
            IProject project = Util.getWorkspaceRoot().getProject(projectName);
            if (!project.exists() || !project.isOpen()) continue;
            size += fileIndexEntry.getValue().size();
        }
        return size;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(2048);
        sb.append("File Index (" + this.fileIndex.size() + " entries):\n");
        for (Map.Entry<IPath, Set<IIndexedJavaRef>> entry : this.fileIndex.entrySet()) {
            sb.append(entry.getKey().toString());
            sb.append(" => \n");
            for (IIndexedJavaRef ref : entry.getValue()) {
                sb.append(MessageFormat.format("    {0}\n", ref));
            }
        }
        sb.append("\n\nElement Index (" + this.elementIndex.size() + " entries):\n");
        for (Map.Entry<Object, Set<IIndexedJavaRef>> entry : this.elementIndex.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append(" => \n");
            for (IIndexedJavaRef ref : entry.getValue()) {
                sb.append(MessageFormat.format("    {0}\n", ref));
            }
        }
        return sb.toString();
    }

    private void addMemberToElementIndex(IIndexedJavaRef ref) {
        this.addToElementIndex(JavaRefIndex.getElementMemberKey(ref.memberSignature()), ref);
    }

    private void addToElementIndex(IIndexedJavaRef ref) {
        String[] stringArray = this.getClassNames(ref);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            this.addToElementIndex(className, ref);
            ++n2;
        }
        if (ref.getMemberOffset() > -1) {
            this.addMemberToElementIndex(ref);
        }
    }

    private void addToElementIndex(String elementKey, IIndexedJavaRef ref) {
        if (this.elementIndex.containsKey(elementKey)) {
            this.elementIndex.get(elementKey).add(ref);
        } else {
            HashSet<IIndexedJavaRef> refs = new HashSet<IIndexedJavaRef>();
            refs.add(ref);
            this.elementIndex.put(elementKey, refs);
        }
    }

    private void addToFileIndex(IIndexedJavaRef ref) {
        IPath file = ref.getSource();
        if (this.fileIndex.containsKey(file)) {
            this.fileIndex.get(file).add(ref);
        } else {
            HashSet<IIndexedJavaRef> refs = new HashSet<IIndexedJavaRef>();
            refs.add(ref);
            this.fileIndex.put(file, refs);
        }
    }

    private Set<IIndexedJavaRef> findElementReferences(String elementKey) {
        Set<IIndexedJavaRef> refs = this.elementIndex.get(elementKey);
        if (refs != null) {
            HashSet<IIndexedJavaRef> copy = new HashSet<IIndexedJavaRef>();
            copy.addAll(refs);
            return copy;
        }
        return Collections.emptySet();
    }

    private String[] getClassNames(IIndexedJavaRef ref) {
        String innermostClassName = ref.className().replace('$', '.');
        List<String> segments = Arrays.asList(Signature.getSimpleNames((String)innermostClassName));
        ArrayList<String> classNames = new ArrayList<String>();
        int i = segments.size() - 1;
        while (i >= 0) {
            if (Character.isLowerCase(segments.get(i).charAt(0))) break;
            String[] classSegments = segments.subList(0, i + 1).toArray(new String[0]);
            String className = Signature.toQualifiedName((String[])classSegments);
            classNames.add(className);
            --i;
        }
        return classNames.toArray(new String[0]);
    }

    private void loadIndex() {
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(JavaRefIndex.getIndexFile());
                this.loadIndex(XMLMemento.createReadRoot((Reader)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            GWTPluginLog.logError(e, "Error loading search index");
        }
    }

    private void loadIndex(XMLMemento memento) {
        IMemento[] iMementoArray = memento.getChildren(TAG_JAVA_REF);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento refNode = iMementoArray[n2];
            IIndexedJavaRef ref = this.loadJavaRef(refNode);
            if (ref != null) {
                this.add(ref);
            }
            ++n2;
        }
    }

    private IIndexedJavaRef loadJavaRef(IMemento refNode) {
        Object ref;
        String refClassName;
        block8: {
            Class<?> refClass;
            block7: {
                refClassName = refNode.getString(TAG_JAVA_REF_CLASS);
                if (refClassName == null) {
                    GWTPluginLog.logError("Missing attribute '{0}' for element '{1}' in search index file", TAG_JAVA_REF_CLASS, TAG_JAVA_REF);
                    return null;
                }
                refClass = Class.forName(refClassName);
                if (IIndexedJavaRef.class.isAssignableFrom(refClass)) break block7;
                GWTPluginLog.logError("{0} does not implement {1}", refClassName, IIndexedJavaRef.class.getSimpleName());
                return null;
            }
            Method loadMethod = refClass.getDeclaredMethod(JAVA_REF_LOAD_METHOD, IMemento.class);
            ref = loadMethod.invoke(null, refNode);
            if (ref instanceof IIndexedJavaRef) break block8;
            GWTPluginLog.logError("Return value of {0}.{1} does not return a {2}", refClassName, JAVA_REF_LOAD_METHOD, IIndexedJavaRef.class.getSimpleName());
            return null;
        }
        try {
            return (IIndexedJavaRef)ref;
        }
        catch (ClassNotFoundException e) {
            GWTPluginLog.logError("Could not find Java ref type " + refClassName);
        }
        catch (NoSuchMethodException e) {
            GWTPluginLog.logError("The Java ref type {0} is missing the static method '{1}'", refClassName, JAVA_REF_LOAD_METHOD);
        }
        catch (Exception e) {
            GWTPluginLog.logError(e);
        }
        return null;
    }

    private void removeRefsFromElementIndex(IIndexedJavaRef ref, IPath file) {
        String[] stringArray = this.getClassNames(ref);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            this.removeRefsFromElementIndex(className, file);
            ++n2;
        }
        if (ref.getMemberOffset() > -1) {
            this.removeRefsFromElementIndex(JavaRefIndex.getElementMemberKey(ref.memberSignature()), file);
        }
    }

    private void removeRefsFromElementIndex(String elementKey, IPath file) {
        assert (this.elementIndex.containsKey(elementKey));
        Set<IIndexedJavaRef> elementRefs = this.elementIndex.get(elementKey);
        Iterator<IIndexedJavaRef> i = elementRefs.iterator();
        while (i.hasNext()) {
            if (!i.next().getSource().equals((Object)file)) continue;
            i.remove();
        }
    }

    private void saveIndex() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_JAVA_REFS);
        this.saveIndex(memento);
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(JavaRefIndex.getIndexFile());
                memento.save((Writer)writer);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            GWTPluginLog.logError(e, "Error saving search index");
        }
    }

    private void saveIndex(XMLMemento memento) {
        for (Map.Entry<IPath, Set<IIndexedJavaRef>> fileEntry : this.fileIndex.entrySet()) {
            for (IIndexedJavaRef ref : fileEntry.getValue()) {
                IMemento refNode = memento.createChild(TAG_JAVA_REF);
                String refClassName = ref.getClass().getName();
                refNode.putString(TAG_JAVA_REF_CLASS, refClassName);
                ref.save(refNode);
            }
        }
    }
}

