/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.search;

import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gwt.eclipse.core.search.IIndexedJavaRef;
import com.google.gwt.eclipse.core.util.Util;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.ui.IMemento;

public class JsniJavaRefParamType
implements IIndexedJavaRef {
    private static final String TAG_OFFSET = "offset";
    private static final String TAG_SOURCE = "source";
    private final int offset;
    private final IPath source;
    private final String paramTypeString;
    private final String rawClassName;
    private final String className;

    public static JsniJavaRefParamType load(IMemento memento) {
        String refString = memento.getTextData();
        if (refString == null) {
            return null;
        }
        String sourceString = memento.getString(TAG_SOURCE);
        if (sourceString == null) {
            return null;
        }
        Integer offset = memento.getInteger(TAG_OFFSET);
        if (offset == null) {
            return null;
        }
        return JsniJavaRefParamType.parse((IPath)new Path(sourceString), offset, refString);
    }

    public static JsniJavaRefParamType parse(IPath source, int offset, String paramTypeString) {
        if (paramTypeString.length() < 3 || !paramTypeString.endsWith(";")) {
            return null;
        }
        if (Signature.getTypeSignatureKind((String)paramTypeString) != 1) {
            return null;
        }
        return new JsniJavaRefParamType(source, offset, paramTypeString);
    }

    private JsniJavaRefParamType(IPath source, int offset, String paramTypeString) {
        this.source = source;
        this.offset = offset;
        this.paramTypeString = paramTypeString;
        this.rawClassName = paramTypeString.substring(1, paramTypeString.length() - 1);
        this.className = this.rawClassName.replace('/', '.');
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public int getClassOffset() {
        return this.offset + 1;
    }

    @Override
    public int getMemberOffset() {
        return -1;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public IPath getSource() {
        return this.source;
    }

    @Override
    public String memberName() {
        return null;
    }

    @Override
    public String memberSignature() {
        return null;
    }

    @Override
    public String rawClassName() {
        return this.rawClassName;
    }

    @Override
    public IJavaElement resolve() {
        IProject project = Util.getProject(this.getSource());
        if (project == null) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return null;
        }
        return JavaModelSearch.findType((IJavaProject)javaProject, (String)this.className());
    }

    @Override
    public void save(IMemento memento) {
        memento.putTextData(this.paramTypeString);
        memento.putString(TAG_SOURCE, this.getSource().toString());
        memento.putInteger(TAG_OFFSET, this.getOffset());
    }
}

