/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder;

import com.google.gdt.eclipse.core.collections.OneToManyIndex;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PackageBasedNamespaceManager {
    private final OneToManyIndex<String, String> packageNameToPrefix = new OneToManyIndex();
    private final ArbitraryPrefixGenerator arbitraryPrefixGenerator = new ArbitraryPrefixGenerator();

    private static int getLastUncommonFragmentIndex(String[] fragments) {
        int i = fragments.length - 1;
        while (i >= 0) {
            if (!PackageBasedNamespaceManager.isCommonFragment(fragments[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static String getStandardPrefix(String packageName) {
        if (packageName.equals("com.google.gwt.user.client.ui")) {
            return "g";
        }
        return null;
    }

    private static boolean isCommonFragment(String fragment) {
        return fragment.equals("client") || fragment.equals("ui") || fragment.equals("widget") || fragment.equals("widgets");
    }

    public Set<String> getImportedPackageNames() {
        return this.packageNameToPrefix.keys();
    }

    public String getPackageName(String prefix) {
        Set packageNames = this.packageNameToPrefix.getKeys((Object)prefix);
        assert (packageNames.size() <= 1);
        return packageNames.size() == 0 ? null : (String)packageNames.iterator().next();
    }

    public String getPrefix(String packageName) {
        Set elements = this.packageNameToPrefix.getElements((Object)packageName);
        return elements.size() > 0 ? (String)elements.iterator().next() : null;
    }

    public void readFromElement(Element rootElement) {
        NamedNodeMap attributes = rootElement.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            String value;
            Node item = attributes.item(i);
            String namespace = item.getNamespaceURI();
            if (namespace != null && namespace.equals("http://www.w3.org/2000/xmlns/") && (value = item.getNodeValue()) != null && value.startsWith("urn:import:")) {
                String packageName = value.substring("urn:import:".length());
                String nodeName = item.getNodeName();
                String prefix = String.valueOf(item.getPrefix()) + ":";
                if (prefix != null && nodeName.startsWith(prefix)) {
                    nodeName = nodeName.substring(prefix.length());
                }
                this.packageNameToPrefix.addElement((Object)packageName, (Object)nodeName);
            }
            ++i;
        }
    }

    public String resolvePrefix(String packageName) {
        Set allPrefixes = this.packageNameToPrefix.getElements((Object)packageName);
        if (allPrefixes.size() == 0) {
            String prefix = this.computeAvailablePrefix(packageName);
            this.packageNameToPrefix.addElement((Object)packageName, (Object)prefix);
            return prefix;
        }
        return (String)allPrefixes.iterator().next();
    }

    public void writeToElement(Element rootElement) {
        for (String packageName : this.packageNameToPrefix.keys()) {
            for (String prefix : this.packageNameToPrefix.getElements((Object)packageName)) {
                rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, "urn:import:" + packageName);
            }
        }
    }

    private String computeAvailablePrefix(String packageName) {
        String[] fragments;
        int lastUncommonFragmentIndex;
        String curPrefix = PackageBasedNamespaceManager.getStandardPrefix(packageName);
        if (curPrefix != null && !this.packageNameToPrefix.hasElement((Object)curPrefix)) {
            return curPrefix;
        }
        if (packageName.contains(".") && (lastUncommonFragmentIndex = PackageBasedNamespaceManager.getLastUncommonFragmentIndex(fragments = packageName.split("[.]"))) >= 0) {
            curPrefix = fragments[lastUncommonFragmentIndex].substring(0, 1);
            if (!this.packageNameToPrefix.hasElement((Object)curPrefix)) {
                return curPrefix;
            }
            StringBuilder prefixBuilder = new StringBuilder(packageName.length());
            int i = lastUncommonFragmentIndex;
            while (i >= 0) {
                if (i != lastUncommonFragmentIndex) {
                    prefixBuilder.insert(0, '-');
                }
                prefixBuilder.insert(0, fragments[i]);
                if (!this.packageNameToPrefix.hasElement((Object)prefixBuilder.toString())) {
                    return prefixBuilder.toString();
                }
                --i;
            }
        }
        return this.arbitraryPrefixGenerator.computePrefix();
    }

    private class ArbitraryPrefixGenerator {
        private int nextPrefix = 0;

        private ArbitraryPrefixGenerator() {
        }

        String computePrefix() {
            while (PackageBasedNamespaceManager.this.packageNameToPrefix.hasElement((Object)("ns" + ++this.nextPrefix))) {
            }
            return "ns" + this.nextPrefix;
        }
    }
}

