/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.java.ClasspathResourceUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gdt.eclipse.core.java.SignatureUtilities;
import com.google.gdt.eclipse.platform.jdt.model.PlatformJavaModelUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.contentassist.ElExpressionFirstFragmentComputer;
import com.google.gwt.eclipse.core.uibinder.model.reference.UiBinderReferenceManager;
import com.google.gwt.eclipse.core.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public final class UiBinderUtilities {
    private static final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();

    public static ElExpressionFirstFragmentComputer.ElExpressionFirstFragment findMatchingElExpressionFirstFragment(String elExpressionContents, Set<ElExpressionFirstFragmentComputer.ElExpressionFirstFragment> firstFragments) {
        String firstFragmentText = UiBinderUtilities.getFirstFragment(elExpressionContents);
        for (ElExpressionFirstFragmentComputer.ElExpressionFirstFragment firstFragment : firstFragments) {
            if (!firstFragment.getValue().equals(firstFragmentText)) continue;
            return firstFragment;
        }
        return null;
    }

    public static String getAllButFirstFragment(String fragments) {
        int periodIndex = fragments.indexOf(46);
        return periodIndex == -1 ? "" : fragments.substring(periodIndex + 1);
    }

    public static List<IRegion> getElExpressionRegions(String in) {
        Pattern braces = Pattern.compile("[{]([^}]*)[}]");
        Pattern legalFirstChar = Pattern.compile("^[$_a-zA-Z].*");
        ArrayList<IRegion> list = new ArrayList<IRegion>();
        int nextFindStart = 0;
        Matcher m = braces.matcher(in);
        while (m.find(nextFindStart)) {
            String fieldReference = m.group(1);
            if (!legalFirstChar.matcher(fieldReference).matches()) {
                nextFindStart = m.start() + 2;
                continue;
            }
            list.add((IRegion)new Region(m.start(1), m.end(1) - m.start(1)));
            nextFindStart = m.end();
        }
        return list;
    }

    public static String getFirstFragment(String fragments) {
        int periodIndex = fragments.indexOf(46);
        return periodIndex == -1 ? fragments : fragments.substring(0, periodIndex);
    }

    public static int getOpenElExpressionContentsOffset(String text) {
        int lastBrace = text.lastIndexOf(123);
        if (lastBrace == -1) {
            return -1;
        }
        return lastBrace == 0 || text.charAt(lastBrace - 1) != '{' ? lastBrace + 1 : -1;
    }

    public static IType getOwnerType(IType uiBinderSubtype) throws UiBinderException {
        IType ownerType = uiBinderSubtype.getDeclaringType();
        if (ownerType == null) {
            throw new UiBinderException("The UiBinder subtype is not enclosed by an owner class.");
        }
        return ownerType;
    }

    public static String getPackageName(String namespaceUrn) {
        if (namespaceUrn == null || !namespaceUrn.startsWith("urn:import:")) {
            return null;
        }
        String packageName = namespaceUrn.substring("urn:import:".length());
        return Util.isValidPackageName(packageName) ? packageName : null;
    }

    public static List<String> getPathsFromDelimitedString(String delimitedString) {
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(delimitedString.split("[,\\s]+")));
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (path != null && path.length() != 0) continue;
            it.remove();
        }
        return paths;
    }

    public static Set<IType> getSubtypesFromXml(IFile uiXmlFile, IJavaProject javaProject) {
        IPath path;
        try {
            path = ClasspathResourceUtilities.getClasspathRelativePathOfResource((IResource)uiXmlFile, (IJavaProject)javaProject);
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
            return Collections.emptySet();
        }
        Set<IType> subtypes = UiBinderReferenceManager.INSTANCE.getSubtypeToUiXmlIndex().getUiBinderSubtypes(path);
        return subtypes;
    }

    public static IType getUiBinderType(IJavaProject javaProject) {
        try {
            return javaProject.findType("com.google.gwt.uibinder.client.UiBinder");
        }
        catch (JavaModelException e) {
            GWTPluginLog.logWarning(e, "Could not get the UiBinder type.");
            return null;
        }
    }

    public static IPath getUiXmlPath(IType uiBinderSubtype) throws UiBinderException {
        IPath uiBinderPackagePath = uiBinderSubtype.getPackageFragment().getResource().getLocation();
        try {
            Object uiTemplateAnnotation = PlatformJavaModelUtilities.getAnnotation((String)"com.google.gwt.uibinder.client.UiTemplate", (Object)uiBinderSubtype, (IType)uiBinderSubtype);
            if (uiTemplateAnnotation != null) {
                String relativePath = (String)PlatformJavaModelUtilities.getSingleMemberAnnotationValue((Object)uiTemplateAnnotation, String.class);
                return uiBinderPackagePath.append(relativePath);
            }
        }
        catch (JavaModelException e) {
            throw new UiBinderException(e);
        }
        return uiBinderPackagePath.append(String.valueOf(UiBinderUtilities.getOwnerType(uiBinderSubtype).getElementName()) + ".ui.xml");
    }

    public static IType getWidgetType(IJavaProject javaProject) throws JavaModelException, UiBinderException {
        IType widgetType = javaProject.findType("com.google.gwt.user.client.ui", "Widget");
        if (widgetType == null) {
            throw new UiBinderException("Could not resolve the Widget type from the GWT user library.");
        }
        return widgetType;
    }

    public static boolean isUiField(FieldDeclaration fieldDecl) {
        if ((fieldDecl.getModifiers() & 8) != 0) {
            return false;
        }
        return JavaASTUtils.findAnnotation((BodyDeclaration)fieldDecl, (String)"com.google.gwt.uibinder.client.UiField") != null;
    }

    public static boolean isUiHandler(MethodDeclaration method) {
        if ((method.getModifiers() & 8) != 0) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        return JavaASTUtils.findAnnotation((BodyDeclaration)method, (String)"com.google.gwt.uibinder.client.UiHandler") != null;
    }

    public static boolean isUiXml(IFile file) {
        return file.getName().endsWith(".ui.xml");
    }

    public static IType resolveJavaElExpression(IType contextType, String snippet, ElExpressionFragmentVisitor visitor) {
        int offset = 0;
        String[] snippetFragments = snippet.split("[.]");
        IType currentType = contextType;
        int i = 0;
        while (i < snippetFragments.length) {
            block10: {
                String fragment;
                block8: {
                    String returnTypeSignature;
                    IMethod method;
                    block9: {
                        if (i > 0) {
                            offset += snippetFragments[i - 1].length();
                            ++offset;
                        }
                        fragment = snippetFragments[i];
                        ITypeHierarchy hierarchy = currentType.newSupertypeHierarchy((IProgressMonitor)NULL_PROGRESS_MONITOR);
                        method = JavaModelSearch.findMethodInHierarchy((ITypeHierarchy)hierarchy, (IType)currentType, (String)fragment, (String[])new String[0]);
                        if (method == null) break block8;
                        if (visitor != null) {
                            visitor.visitResolvedFragmentMethod(method, offset, fragment.length());
                        }
                        if (!SignatureUtilities.isPrimitiveType((String)(returnTypeSignature = method.getReturnType()))) break block9;
                        if (i != snippetFragments.length - 1 && visitor != null) {
                            visitor.visitNonterminalPrimitiveFragment(fragment, offset, snippet.length() - offset);
                        }
                        return null;
                    }
                    try {
                        IType fragmentType = JavaModelSearch.resolveType((IType)method.getDeclaringType(), (String)returnTypeSignature);
                        if (!JavaModelSearch.isValidElement((IJavaElement)fragmentType)) break block8;
                        currentType = fragmentType;
                        break block10;
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                if (visitor != null) {
                    visitor.visitUnresolvedFragment(fragment, offset, fragment.length(), currentType);
                }
                return null;
            }
            ++i;
        }
        return currentType;
    }

    private UiBinderUtilities() {
    }

    public static interface ElExpressionFragmentVisitor {
        public void visitNonterminalPrimitiveFragment(String var1, int var2, int var3);

        public void visitResolvedFragmentMethod(IMethod var1, int var2, int var3);

        public void visitUnresolvedFragment(String var1, int var2, int var3, IType var4);
    }
}

