/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder;

import com.google.gdt.eclipse.core.JavaUtilities;
import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gdt.eclipse.core.SseUtilities;
import com.google.gdt.eclipse.core.XmlUtilities;
import com.google.gdt.eclipse.core.java.ClasspathResourceUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.UiBinderUtilities;
import com.google.gwt.eclipse.core.uibinder.sse.css.CssExtractor;
import com.google.gwt.eclipse.core.uibinder.sse.css.model.CssResourceAwareModelLoader;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class UiBinderXmlModelUtilities {
    public static String computeQualifiedWidgetTypeName(Node widgetNode) {
        if (widgetNode.getNodeType() != 1) {
            return null;
        }
        String typeName = widgetNode.getLocalName();
        if (typeName.length() == 0 || Character.isLowerCase(typeName.charAt(0))) {
            return null;
        }
        String packageName = UiBinderUtilities.getPackageName(widgetNode.getNamespaceURI());
        return packageName != null ? JavaUtilities.getQualifiedTypeName((String)typeName, (String)packageName) : null;
    }

    public static CssExtractor createCssExtractorForStyleElement(IDOMElement styleElement, IJavaProject javaProject) {
        Node contents;
        String cssBlock = "";
        String externalCssContents = UiBinderXmlModelUtilities.getExternalCssContents(styleElement, javaProject);
        if (externalCssContents != null) {
            cssBlock = String.valueOf(cssBlock) + externalCssContents;
        }
        if ((contents = styleElement.getFirstChild()) != null) {
            cssBlock = String.valueOf(cssBlock) + contents.getNodeValue();
        }
        if (cssBlock.trim().length() == 0) {
            return null;
        }
        return CssExtractor.extract(cssBlock, new CssResourceAwareModelLoader());
    }

    public static Node getFieldAttribute(Node element) {
        String namespace = UiBinderXmlModelUtilities.isWithElement(element) || UiBinderXmlModelUtilities.isStyleElement(element) || UiBinderXmlModelUtilities.isImageElement(element) || UiBinderXmlModelUtilities.isDataElement(element) || UiBinderXmlModelUtilities.isImportElement(element) ? null : "urn:ui:com.google.gwt.uibinder";
        return XmlUtilities.getAttribute((Node)element, (String)"field", (boolean)true, namespace);
    }

    public static Node getSrcAttribute(Node element) {
        if (!(UiBinderXmlModelUtilities.isStyleElement(element) || UiBinderXmlModelUtilities.isImageElement(element) || UiBinderXmlModelUtilities.isDataElement(element))) {
            return null;
        }
        return (IDOMAttr)XmlUtilities.getAttribute((Node)element, (String)"src", (boolean)true, null);
    }

    public static Node getTypeAttribute(Node element) {
        if (!UiBinderXmlModelUtilities.isWithElement(element) && !UiBinderXmlModelUtilities.isStyleElement(element)) {
            return null;
        }
        return XmlUtilities.getAttribute((Node)element, (String)"type", (boolean)true, null);
    }

    public static boolean isDataElement(Node node) {
        return node.getNodeType() == 1 && "urn:ui:com.google.gwt.uibinder".equals(node.getNamespaceURI()) && "data".equalsIgnoreCase(node.getLocalName());
    }

    public static boolean isImageElement(Node node) {
        return node.getNodeType() == 1 && "urn:ui:com.google.gwt.uibinder".equals(node.getNamespaceURI()) && "image".equalsIgnoreCase(node.getLocalName());
    }

    public static boolean isImportElement(Node node) {
        return node.getNodeType() == 1 && "urn:ui:com.google.gwt.uibinder".equals(node.getNamespaceURI()) && "import".equalsIgnoreCase(node.getLocalName());
    }

    public static boolean isStyleElement(Node node) {
        return node.getNodeType() == 1 && "urn:ui:com.google.gwt.uibinder".equals(node.getNamespaceURI()) && "style".equalsIgnoreCase(node.getLocalName());
    }

    public static boolean isUiBinderElement(Node node) {
        return node.getNodeType() == 1 && "urn:ui:com.google.gwt.uibinder".equals(node.getNamespaceURI()) && "UiBinder".equalsIgnoreCase(node.getLocalName());
    }

    public static boolean isUrnImportAttribute(IDOMAttr node) {
        return UiBinderXmlModelUtilities.isUiBinderElement(node.getOwnerElement()) && "http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI()) && node.getNodeValue() != null && node.getNodeValue().startsWith("urn:import:");
    }

    public static boolean isWithElement(Node node) {
        return node.getNodeType() == 1 && "urn:ui:com.google.gwt.uibinder".equals(node.getNamespaceURI()) && "with".equalsIgnoreCase(node.getLocalName());
    }

    public static IType resolveElementToJavaType(IDOMElement element, IJavaProject javaProject) {
        Node typeAttr;
        String qualifiedTypeName = UiBinderXmlModelUtilities.computeQualifiedWidgetTypeName((Node)element);
        if (qualifiedTypeName == null && (typeAttr = UiBinderXmlModelUtilities.getTypeAttribute((Node)element)) != null) {
            qualifiedTypeName = typeAttr.getNodeValue();
        }
        if (qualifiedTypeName == null) {
            if (UiBinderXmlModelUtilities.isImageElement((Node)element)) {
                qualifiedTypeName = "com.google.gwt.resources.client.ImageResource";
            } else if (UiBinderXmlModelUtilities.isDataElement((Node)element)) {
                qualifiedTypeName = "com.google.gwt.resources.client.DataResource";
            } else if (UiBinderXmlModelUtilities.isImportElement((Node)element)) {
                Node node = UiBinderXmlModelUtilities.getFieldAttribute((Node)element);
                if (node == null) {
                    return null;
                }
                String qualifiedConstant = node.getNodeValue();
                int index = qualifiedConstant.lastIndexOf(46);
                if (index != -1) {
                    qualifiedTypeName = qualifiedConstant.substring(0, index);
                }
            }
        }
        if (qualifiedTypeName == null) {
            return null;
        }
        try {
            return javaProject.findType(qualifiedTypeName);
        }
        catch (JavaModelException e) {
            GWTPluginLog.logWarning(e, "Could not resolve element to Java type.");
            return null;
        }
    }

    public static String resolveUiBinderNamespacePrefix(IDOMModel xmlModel) {
        Element element = xmlModel.getDocument().getDocumentElement();
        if (element == null) {
            return null;
        }
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node item = attributes.item(i);
            if (item.getNamespaceURI() != null && item.getNodeValue() != null && item.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") && item.getNodeValue().equals("urn:ui:com.google.gwt.uibinder")) {
                return item.getLocalName();
            }
            ++i;
        }
        return null;
    }

    public static String resolveUiBinderNamespacePrefix(IStructuredDocument xmlDocument) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)xmlDocument);
        if (model == null || !(model instanceof IDOMModel)) {
            return null;
        }
        try {
            String string = UiBinderXmlModelUtilities.resolveUiBinderNamespacePrefix((IDOMModel)model);
            return string;
        }
        finally {
            model.releaseFromRead();
        }
    }

    private static String getExternalCssContents(IDOMElement styleElement, IJavaProject javaProject) {
        Node srcAttr;
        IPath dirClasspathRelativePath;
        block9: {
            IPath xmlClasspathRelativePath;
            block8: {
                IFile xmlFile;
                block7: {
                    xmlFile = SseUtilities.resolveFile((IStructuredModel)styleElement.getModel());
                    if (xmlFile != null) break block7;
                    return null;
                }
                xmlClasspathRelativePath = ClasspathResourceUtilities.getClasspathRelativePathOfResource((IResource)xmlFile, (IJavaProject)javaProject);
                if (xmlClasspathRelativePath != null) break block8;
                return null;
            }
            dirClasspathRelativePath = xmlClasspathRelativePath.removeLastSegments(1);
            srcAttr = UiBinderXmlModelUtilities.getSrcAttribute((Node)styleElement);
            if (srcAttr != null && srcAttr.getNodeValue() != null) break block9;
            return null;
        }
        try {
            StringBuilder cssBlock = new StringBuilder();
            for (String cssClasspathRelativePathString : UiBinderUtilities.getPathsFromDelimitedString(srcAttr.getNodeValue())) {
                IPath cssClasspathRelativePath = dirClasspathRelativePath.append(cssClasspathRelativePathString);
                IFile cssFile = (IFile)ClasspathResourceUtilities.resolveFile((IPath)cssClasspathRelativePath, (IJavaProject)javaProject);
                if (cssFile == null) continue;
                cssBlock.append(ResourceUtils.readFileContents((IPath)cssFile.getLocation()));
            }
            return cssBlock.toString();
        }
        catch (JavaModelException e) {
            GWTPluginLog.logWarning(e, "Could not get external CSS file contents.");
        }
        catch (IOException e) {
            GWTPluginLog.logWarning(e, "Could not get external CSS file contents.");
        }
        return null;
    }

    private UiBinderXmlModelUtilities() {
    }
}

