/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist;

import com.google.gdt.eclipse.core.XmlUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.UiBinderUtilities;
import com.google.gwt.eclipse.core.uibinder.UiBinderXmlModelUtilities;
import com.google.gwt.eclipse.core.uibinder.problems.UiBinderProblemMarkerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ElExpressionFirstFragmentComputer {
    private final Set<ElExpressionFirstFragment> duplicateFirstFragments;
    private final Set<ElExpressionFirstFragment> firstFragments;

    public static ElExpressionFirstFragmentComputer compute(Document document, final IFile xmlFile, final IJavaProject javaProject, final UiBinderProblemMarkerManager problemMarkerManager) {
        final HashSet<ElExpressionFirstFragment> fragments = new HashSet<ElExpressionFirstFragment>();
        final HashSet<ElExpressionFirstFragment> dupFragments = new HashSet<ElExpressionFirstFragment>();
        XmlUtilities.visitNodes((Node)document, (XmlUtilities.NodeVisitor)new XmlUtilities.NodeVisitor(){

            public boolean visitNode(Node node) {
                if (node.getNodeType() != 1) {
                    return true;
                }
                ArrayList<ElExpressionFirstFragment> currentFirstFragments = new ArrayList<ElExpressionFirstFragment>();
                if (!UiBinderXmlModelUtilities.isImportElement(node)) {
                    ElExpressionFirstFragment elExpressionFirstFragment = this.createFirstFragmentWithFieldAttribute(node);
                    if (elExpressionFirstFragment == null && UiBinderXmlModelUtilities.isStyleElement(node)) {
                        elExpressionFirstFragment = new ElExpressionFirstFragment("style", node);
                    }
                    if (elExpressionFirstFragment != null) {
                        currentFirstFragments.add(elExpressionFirstFragment);
                    }
                } else {
                    List<ElExpressionFirstFragment> imports = this.getFirstFragmentsFromImport(node);
                    currentFirstFragments.addAll(imports);
                }
                for (ElExpressionFirstFragment elExpressionFirstFragment : currentFirstFragments) {
                    ElExpressionFirstFragment fragment = this.findFragment(elExpressionFirstFragment.getValue());
                    if (fragment != null) {
                        dupFragments.add(fragment);
                        dupFragments.add(elExpressionFirstFragment);
                        continue;
                    }
                    fragments.add(elExpressionFirstFragment);
                }
                return true;
            }

            private ImportResult canImportField(IField field) {
                block7: {
                    try {
                        int flags = field.getFlags();
                        if (!Flags.isStatic((int)flags)) {
                            if (Flags.isEnum((int)flags)) {
                                return ImportResult.YES;
                            }
                            return ImportResult.FIELD_NOT_STATIC;
                        }
                        if (Flags.isPrivate((int)flags)) {
                            return ImportResult.FIELD_NOT_VISIBLE;
                        }
                        if (!Flags.isProtected((int)flags) && !Flags.isPackageDefault((int)flags)) break block7;
                        IPackageDeclaration[] decs = field.getCompilationUnit().getPackageDeclarations();
                        if (decs.length > 0 && xmlFile != null) {
                            String enclosingTypeDec = decs[0].getElementName();
                            Set<IType> ownerTypes = UiBinderUtilities.getSubtypesFromXml(xmlFile, javaProject);
                            for (IType type : ownerTypes) {
                                if (enclosingTypeDec.equals(type.getPackageFragment().getElementName())) continue;
                                return ImportResult.FIELD_NOT_VISIBLE;
                            }
                            break block7;
                        }
                        return ImportResult.TYPE_NOT_VISIBLE;
                    }
                    catch (JavaModelException e) {
                        return ImportResult.ERROR;
                    }
                }
                return ImportResult.YES;
            }

            private IType computeFirstInaccessibleType(IType t1, IType t2) {
                boolean samePackage;
                int flags;
                try {
                    flags = t1.getFlags();
                }
                catch (JavaModelException e) {
                    return t1;
                }
                if (Flags.isPrivate((int)flags)) {
                    return t1;
                }
                if ((Flags.isProtected((int)flags) || Flags.isPackageDefault((int)flags)) && !(samePackage = t1.getPackageFragment().getElementName().equals(t2.getPackageFragment().getElementName()))) {
                    return t1;
                }
                if (t1.getParent() instanceof IType) {
                    return this.computeFirstInaccessibleType((IType)t1.getParent(), t2);
                }
                return null;
            }

            private ElExpressionFirstFragment createFirstFragmentWithFieldAttribute(Node node) {
                Node fieldAttr = UiBinderXmlModelUtilities.getFieldAttribute(node);
                if (fieldAttr == null || fieldAttr.getNodeValue() == null) {
                    return null;
                }
                ElExpressionFirstFragment elExpressionFirstFragment = new ElExpressionFirstFragment(fieldAttr.getNodeValue(), node);
                return elExpressionFirstFragment;
            }

            private ElExpressionFirstFragment findFragment(String fragmentStr) {
                for (ElExpressionFirstFragment curFragment : fragments) {
                    if (!curFragment.getValue().equals(fragmentStr)) continue;
                    return curFragment;
                }
                return null;
            }

            private List<ElExpressionFirstFragment> getFirstFragmentsFromImport(Node node) {
                IField field;
                IField[] fields;
                Node importFieldNode = UiBinderXmlModelUtilities.getFieldAttribute(node);
                if (importFieldNode == null) {
                    this.markProblem(node, ImportResult.IMPORT_MISSING_FIELD_ATTR);
                    return Collections.emptyList();
                }
                String importFieldValue = importFieldNode.getNodeValue();
                String lastFragment = importFieldValue.substring(importFieldValue.lastIndexOf(46) + 1);
                if (lastFragment.length() == 0) {
                    this.markProblem(importFieldNode, ImportResult.TYPE_UNDEFINED);
                    return Collections.emptyList();
                }
                IType enclosingType = UiBinderXmlModelUtilities.resolveElementToJavaType((IDOMElement)node, javaProject);
                if (enclosingType == null) {
                    this.markProblem(importFieldNode, ImportResult.TYPE_UNDEFINED);
                    return Collections.emptyList();
                }
                if (xmlFile != null) {
                    boolean problemFound = false;
                    Set<IType> subtypes = UiBinderUtilities.getSubtypesFromXml(xmlFile, javaProject);
                    for (IType type : subtypes) {
                        IType inaccessibleType = this.computeFirstInaccessibleType(enclosingType, type);
                        if (inaccessibleType == null) continue;
                        this.markProblem(importFieldNode, ImportResult.TYPE_NOT_VISIBLE, inaccessibleType.getFullyQualifiedName('.'));
                        problemFound = true;
                    }
                    if (problemFound) {
                        return Collections.emptyList();
                    }
                }
                ArrayList<ElExpressionFirstFragment> fragments2 = new ArrayList<ElExpressionFirstFragment>();
                try {
                    fields = enclosingType.getFields();
                }
                catch (JavaModelException e) {
                    GWTPluginLog.logError(e);
                    return Collections.emptyList();
                }
                if ("*".equals(lastFragment)) {
                    IField[] iFieldArray = fields;
                    int inaccessibleType = fields.length;
                    int n = 0;
                    while (n < inaccessibleType) {
                        field = iFieldArray[n];
                        if (this.canImportField(field) == ImportResult.YES) {
                            ElExpressionFirstFragment elExpressionFirstFragment = new ElExpressionFirstFragment(field.getElementName(), node);
                            fragments2.add(elExpressionFirstFragment);
                        }
                        ++n;
                    }
                } else {
                    field = JavaModelSearch.findField((IType)enclosingType, (String)lastFragment);
                    if (field != null) {
                        ImportResult ir = this.canImportField(field);
                        if (ir == ImportResult.YES) {
                            ElExpressionFirstFragment elExpressionFirstFragment = new ElExpressionFirstFragment(lastFragment, node);
                            fragments2.add(elExpressionFirstFragment);
                        } else {
                            this.markProblem(importFieldNode, ir);
                        }
                    } else {
                        this.markProblem(importFieldNode, ImportResult.FIELD_UNDEFINED);
                    }
                }
                return fragments2;
            }

            private void markProblem(Node node, ImportResult ir) {
                this.markProblem(node, ir, null);
            }

            private void markProblem(Node node, ImportResult ir, String text) {
                if (problemMarkerManager != null) {
                    IRegion region;
                    if (text == null) {
                        text = node.getNodeValue();
                    }
                    if (node instanceof IDOMAttr) {
                        region = XmlUtilities.getAttributeValueRegion((IDOMAttr)((IDOMAttr)node));
                    } else if (node instanceof IDOMElement) {
                        int start = ((IDOMElement)node).getStartOffset();
                        int end = ((IDOMElement)node).getStartEndOffset();
                        region = new Region(start, end - start);
                    } else {
                        return;
                    }
                    switch (ir) {
                        case FIELD_NOT_STATIC: {
                            problemMarkerManager.setFieldNotStaticError(region, text);
                            break;
                        }
                        case FIELD_NOT_VISIBLE: {
                            problemMarkerManager.setFieldNotVisibleError(region, text);
                            break;
                        }
                        case FIELD_UNDEFINED: {
                            problemMarkerManager.setFieldUndefinedError(region, text);
                            break;
                        }
                        case TYPE_NOT_VISIBLE: {
                            problemMarkerManager.setTypeNotVisibleError(region, text);
                            break;
                        }
                        case TYPE_UNDEFINED: {
                            problemMarkerManager.setTypeUndefinedError(region, text);
                            break;
                        }
                        case IMPORT_MISSING_FIELD_ATTR: {
                            problemMarkerManager.setImportMissingFieldAttr(region, text);
                            break;
                        }
                        default: {
                            GWTPluginLog.logWarning("Unknown UiBinder XML problem type: " + ir.toString());
                        }
                    }
                }
            }
        });
        return new ElExpressionFirstFragmentComputer(fragments, dupFragments);
    }

    private ElExpressionFirstFragmentComputer(Set<ElExpressionFirstFragment> firstFragments, Set<ElExpressionFirstFragment> duplicateFirstFragments) {
        this.firstFragments = firstFragments;
        this.duplicateFirstFragments = duplicateFirstFragments;
    }

    public Set<ElExpressionFirstFragment> getDuplicateFirstFragments() {
        return this.duplicateFirstFragments;
    }

    public Set<ElExpressionFirstFragment> getFirstFragments() {
        return this.firstFragments;
    }

    public static class ElExpressionFirstFragment {
        private final Node node;
        private final String value;

        public ElExpressionFirstFragment(String value, Node node) {
            this.value = value;
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    private static enum ImportResult {
        ERROR,
        FIELD_NOT_STATIC,
        FIELD_NOT_VISIBLE,
        FIELD_UNDEFINED,
        IMPORT_MISSING_FIELD_ATTR,
        TYPE_NOT_VISIBLE,
        TYPE_UNDEFINED,
        YES;

    }
}

