/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist;

import com.google.gwt.eclipse.core.uibinder.contentassist.AbstractCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ReplacementCompletionProposal
extends AbstractCompletionProposal {
    public static final int DEFAULT_CURSOR_POSITION = Integer.MIN_VALUE;
    private final String text;
    private final int offset;
    private final int length;
    private final int cursorPosition;

    public static ReplacementCompletionProposal fromExistingCompletionProposal(String text, int offset, int length, ICompletionProposal existingCompletionProposal) {
        if (existingCompletionProposal != null) {
            return new ReplacementCompletionProposal(text, offset, length, Integer.MIN_VALUE, existingCompletionProposal.getAdditionalProposalInfo(), existingCompletionProposal.getDisplayString(), existingCompletionProposal.getImage());
        }
        return new ReplacementCompletionProposal(text, offset, length);
    }

    public ReplacementCompletionProposal(String text, int offset, int length) {
        this(text, offset, length, Integer.MIN_VALUE, null, null, null);
    }

    public ReplacementCompletionProposal(String text, int offset, int length, int cursorPosition) {
        this(text, offset, length, cursorPosition, null, null, null);
    }

    public ReplacementCompletionProposal(String text, int offset, int length, int cursorPosition, String additionalProposalInfo, String displayString, Image image) {
        super(additionalProposalInfo, displayString != null ? displayString : text, image);
        this.text = text;
        this.offset = offset;
        this.length = length;
        this.cursorPosition = cursorPosition;
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this.cursorPosition == Integer.MIN_VALUE) {
            if (this.length > 0) {
                return null;
            }
            return new Point(this.offset + this.text.length(), 0);
        }
        return new Point(this.cursorPosition, 0);
    }

    @Override
    public void onApply(IDocument document, ITextViewer viewer) throws BadLocationException {
        document.replace(this.offset, this.length, this.text);
    }
}

