/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist;

import com.google.gdt.eclipse.core.JavaProjectUtilities;
import com.google.gdt.eclipse.core.SseUtilities;
import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.XmlUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.PackageBasedNamespaceManager;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.UiBinderUtilities;
import com.google.gwt.eclipse.core.uibinder.contentassist.DelegatingTextViewer;
import com.google.gwt.eclipse.core.uibinder.contentassist.IProposalComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.ElExpressionProposalComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.ProposalComputerFactory;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.WidgetProposalComputer;
import com.google.gwt.eclipse.core.uibinder.sse.StructuredTextPartitionerForUiBinderXml;
import com.google.gwt.eclipse.core.uibinder.text.IDocumentPartitionerFactory;
import com.google.gwt.eclipse.core.uibinder.text.StructuredDocumentCloner;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;

public class UiBinderXmlCompletionProcessor
extends XMLContentAssistProcessor {
    private IJavaProject javaProject;
    private String filePackageName;
    private boolean addedDynamicWidgetProposals;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        this.rememberJavaProject(textViewer.getDocument());
        this.addedDynamicWidgetProposals = false;
        DtdRemover dtdRemover = DtdRemover.create(textViewer, documentPosition);
        try {
            List<ICompletionProposal> proposals;
            if (dtdRemover != null) {
                textViewer = dtdRemover.textViewer;
            }
            if ((proposals = this.getWstCompletionProposals(textViewer, documentPosition)) == null) {
                return null;
            }
            Collections.sort(proposals, new CompletionProposalComparator());
            if (this.addedDynamicWidgetProposals) {
                this.removeSchemaWidgetProposals(proposals, textViewer.getDocument());
            }
            this.removeSchemaUiBinderElementProposal((IStructuredDocument)textViewer.getDocument(), proposals);
            ICompletionProposal[] iCompletionProposalArray = proposals.toArray(new ICompletionProposal[proposals.size()]);
            return iCompletionProposalArray;
        }
        finally {
            if (dtdRemover != null) {
                dtdRemover.release();
            }
        }
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest) {
        super.addAttributeNameProposals(contentAssistRequest);
        this.addProposals(contentAssistRequest, ProposalComputerFactory.newUiFieldAttributeProposalComputer(contentAssistRequest), ProposalComputerFactory.newUiPhAttributeProposalComputer(contentAssistRequest), ProposalComputerFactory.newSetterAttributeProposalComputer(contentAssistRequest, this.javaProject));
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
        super.addAttributeValueProposals(contentAssistRequest);
        if (this.javaProject != null) {
            this.addProposals(contentAssistRequest, ElExpressionProposalComputer.newUsingContentAssistRequest(contentAssistRequest, this.javaProject), ProposalComputerFactory.newUiImportFieldProposalComputer(contentAssistRequest, this.javaProject, this.filePackageName), ProposalComputerFactory.newWithTypeProposalComputer(contentAssistRequest, this.javaProject), ProposalComputerFactory.newUrnImportProposalComputer(contentAssistRequest, this.javaProject), ProposalComputerFactory.newUrnTypesProposalComputer(contentAssistRequest), ProposalComputerFactory.newUiFieldProposalComputer(contentAssistRequest, this.javaProject));
        }
    }

    protected void addTagNameProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        super.addTagNameProposals(contentAssistRequest, childPosition);
        if (this.javaProject != null) {
            this.addProposals(contentAssistRequest, ProposalComputerFactory.newUiBinderRootElementProposalComputer(contentAssistRequest));
            if (this.addProposals(contentAssistRequest, WidgetProposalComputer.newUsingContentAssistRequest(contentAssistRequest, this.javaProject))) {
                this.addedDynamicWidgetProposals = true;
            }
        }
    }

    private boolean addProposals(ContentAssistRequest contentAssistRequest, IProposalComputer ... proposalComputers) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        IProposalComputer[] iProposalComputerArray = proposalComputers;
        int n = proposalComputers.length;
        int n2 = 0;
        while (n2 < n) {
            IProposalComputer proposalComputer = iProposalComputerArray[n2];
            if (proposalComputer != null) {
                try {
                    proposalComputer.computeProposals(proposals);
                }
                catch (UiBinderException e) {
                    GWTPluginLog.logWarning(e, MessageFormat.format("Could not compute proposals for {0}.", proposalComputer.getClass().getSimpleName()));
                    return false;
                }
            }
            ++n2;
        }
        for (ICompletionProposal proposal : proposals) {
            contentAssistRequest.addProposal(proposal);
        }
        return proposals.size() > 0;
    }

    private List<ICompletionProposal> getWstCompletionProposals(ITextViewer textViewer, int documentPosition) {
        ICompletionProposal[] proposals = super.computeCompletionProposals(textViewer, documentPosition);
        if (proposals == null || proposals.length == 0) {
            return null;
        }
        return new ArrayList<ICompletionProposal>(Arrays.asList(proposals));
    }

    private void rememberJavaProject(IDocument document) {
        Set<IType> types;
        IFile file = SseUtilities.resolveFile((IDocument)document);
        if (file != null) {
            this.javaProject = JavaCore.create((IProject)file.getProject());
            if (!JavaProjectUtilities.isJavaProjectNonNullAndExists((IJavaProject)this.javaProject)) {
                this.javaProject = null;
                return;
            }
        }
        if ((types = UiBinderUtilities.getSubtypesFromXml(file, this.javaProject)).size() > 0) {
            IType type = types.iterator().next();
            this.filePackageName = type.getPackageFragment().getElementName();
        }
    }

    private void removeSchemaUiBinderElementProposal(IStructuredDocument document, List<ICompletionProposal> proposals) {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)document);
        try {
            IDOMElement rootElement = (IDOMElement)model.getDocument().getDocumentElement();
            if (rootElement == null) {
                return;
            }
            Iterator<ICompletionProposal> it = proposals.iterator();
            while (it.hasNext()) {
                ICompletionProposal proposal = it.next();
                if (!rootElement.getNodeName().equals(proposal.getDisplayString())) continue;
                it.remove();
            }
        }
        finally {
            model.releaseFromRead();
        }
    }

    private void removeSchemaWidgetProposals(List<ICompletionProposal> proposals, IDocument document) {
        PackageBasedNamespaceManager packageManager = new PackageBasedNamespaceManager();
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(document);
        try {
            packageManager.readFromElement(model.getDocument().getDocumentElement());
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        Iterator<ICompletionProposal> it = proposals.iterator();
        while (it.hasNext()) {
            String widgetName;
            String packageName;
            String displayString;
            String prefix;
            ICompletionProposal proposal = it.next();
            if (!(proposal instanceof CustomCompletionProposal) || (prefix = XmlUtilities.getPrefix((String)(displayString = proposal.getDisplayString()))) == null || (packageName = packageManager.getPackageName(prefix)) == null || (widgetName = XmlUtilities.getUnprefixed((String)displayString)).length() == 0 || !Character.isUpperCase(widgetName.charAt(0))) continue;
            it.remove();
        }
    }

    private static class DocumentChangingTextViewer
    extends DelegatingTextViewer {
        private final IDocument document;

        public DocumentChangingTextViewer(ITextViewer originalTextViewer, IDocument document) {
            super(originalTextViewer);
            this.document = document;
        }

        @Override
        public IDocument getDocument() {
            return this.document;
        }
    }

    private static class DtdRemover {
        public final ITextViewer textViewer;
        private final IStructuredDocument clonedDocument;
        private final StructuredDocumentCloner documentCloner;

        private static DtdRemover create(ITextViewer textViewer, int documentPosition) {
            IDocumentPartitionerFactory docPartitionerFactory = new IDocumentPartitionerFactory(){

                @Override
                public IDocumentPartitioner createDocumentPartitioner() {
                    return new StructuredTextPartitionerForUiBinderXml();
                }
            };
            StructuredDocumentCloner structuredDocumentCloner = new StructuredDocumentCloner("org.eclipse.wst.xml.XML_DEFAULT", docPartitionerFactory);
            IStructuredDocument clonedDoc = structuredDocumentCloner.clone(textViewer.getDocument());
            if (clonedDoc == null) {
                return null;
            }
            IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)clonedDoc);
            try {
                IDOMNode docType = (IDOMNode)model.getDocument().getDoctype();
                if (docType == null) {
                    return null;
                }
                IStructuredDocumentRegion firstRegion = docType.getFirstStructuredDocumentRegion();
                IStructuredDocumentRegion lastRegion = docType.getLastStructuredDocumentRegion();
                int firstPos = firstRegion.getStartOffset();
                int lastPos = lastRegion.getEndOffset();
                int docTypeLen = lastPos - firstPos;
                if (docTypeLen == 0 || documentPosition >= firstPos && documentPosition <= lastPos) {
                    return null;
                }
                try {
                    clonedDoc.replace(firstPos, docTypeLen, StringUtilities.repeatCharacter((char)' ', (int)docTypeLen));
                }
                catch (BadLocationException e) {
                    GWTPluginLog.logError(e, "Unexpected bad location while removing doctype");
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    return null;
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
            return new DtdRemover(new DocumentChangingTextViewer(textViewer, (IDocument)clonedDoc), documentPosition, structuredDocumentCloner, clonedDoc);
        }

        private DtdRemover(ITextViewer textViewer, int documentPosition, StructuredDocumentCloner documentCloner, IStructuredDocument clonedDocument) {
            this.textViewer = textViewer;
            this.documentCloner = documentCloner;
            this.clonedDocument = clonedDocument;
        }

        public void release() {
            this.documentCloner.release((IDocument)this.clonedDocument);
        }
    }
}

