/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist.computers;

import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.AbstractJavaProposalComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.ProposalGeneratingCompletionRequestor;
import java.util.List;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class CodeCompleteProposalComputer
extends AbstractJavaProposalComputer {
    private final int[] allowedCompletionTypes;
    private final String packageName;
    private final boolean forceFullyQualifiedFieldNames;

    public static void completeCodeUsingAlphabet(IEvaluationContext evalContext, ProposalGeneratingCompletionRequestor requestor) throws JavaModelException {
        char letter = 'a';
        while (letter <= 'z') {
            evalContext.codeComplete(String.valueOf(letter), 1, (CompletionRequestor)requestor);
            if (requestor.getProposals().size() > 0) {
                return;
            }
            letter = (char)(letter + '\u0001');
        }
    }

    public CodeCompleteProposalComputer(int[] allowedCompletionTypes, IJavaProject javaProject, String enteredText, int replaceOffset, int replaceLength, String packageName, boolean forceFullyQualifiedFieldNames) {
        super(javaProject, enteredText, replaceOffset, replaceLength);
        this.allowedCompletionTypes = allowedCompletionTypes;
        this.packageName = packageName;
        this.forceFullyQualifiedFieldNames = forceFullyQualifiedFieldNames;
    }

    @Override
    public void computeProposals(List<ICompletionProposal> proposals) throws UiBinderException {
        try {
            IEvaluationContext evalContext = this.createEvaluationContext();
            if (this.packageName != null) {
                evalContext.setPackageName(this.packageName);
            }
            ProposalGeneratingCompletionRequestor requestor = new ProposalGeneratingCompletionRequestor(this.getReplaceOffset(), this.getReplaceLength(), this.allowedCompletionTypes, this.getJavaProject(), this.forceFullyQualifiedFieldNames);
            if (this.getEnteredText().trim().length() == 0) {
                CodeCompleteProposalComputer.completeCodeUsingAlphabet(evalContext, requestor);
            } else {
                evalContext.codeComplete(this.getEnteredText(), this.getEnteredText().length(), (CompletionRequestor)requestor);
            }
            proposals.addAll(requestor.getProposals());
        }
        catch (JavaModelException e) {
            throw new UiBinderException(e);
        }
    }
}

