/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist.computers;

import com.google.gwt.eclipse.core.uibinder.sse.css.CssModelUtilities;
import com.google.gwt.uibinder.attributeparsers.CssNameConverter;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPageRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;

public class CssSelectorNameCollector
implements CssModelUtilities.CssNodeVisitor {
    private final Set<String> selectorNames = new HashSet<String>();

    public static String getDuplicateSelectorNamesErrorMessage(ICSSNode node) {
        Set<String> literalSelectorNames = CssSelectorNameCollector.getLiteralSelectorNames(node);
        CssNameConverter cssNameConverter = new CssNameConverter();
        try {
            cssNameConverter.convertSet(literalSelectorNames);
            return null;
        }
        catch (CssNameConverter.Failure e) {
            return e.getMessage();
        }
    }

    public static Set<String> getLiteralSelectorNames(ICSSNode node) {
        CssSelectorNameCollector collector = new CssSelectorNameCollector();
        CssModelUtilities.visitCssNodes(node, collector);
        return collector.getSelectorNames();
    }

    public static Set<String> getValidSelectorNames(ICSSNode node) {
        Set<String> literalSelectorNames = CssSelectorNameCollector.getLiteralSelectorNames(node);
        HashSet<String> validSelectorNames = new HashSet<String>(literalSelectorNames);
        CssNameConverter cssNameConverter = new CssNameConverter();
        for (String selectorName : literalSelectorNames) {
            validSelectorNames.add(cssNameConverter.convertName(selectorName));
        }
        return validSelectorNames;
    }

    @Override
    public void visitCssNode(ICSSNode cssNode) {
        ICSSSelectorList selectors;
        switch (cssNode.getNodeType()) {
            case 1: {
                selectors = ((ICSSStyleRule)cssNode).getSelectors();
                break;
            }
            case 6: {
                selectors = ((ICSSPageRule)cssNode).getSelectors();
                break;
            }
            default: {
                return;
            }
        }
        int selectorPos = 0;
        while (selectorPos < selectors.getLength()) {
            ICSSSelector selector = selectors.getSelector(selectorPos);
            int itemPos = 0;
            while (itemPos < selector.getLength()) {
                ICSSSelectorItem item = selector.getItem(itemPos);
                if (item.getItemType() == 1) {
                    ICSSSimpleSelector simpleItem = (ICSSSimpleSelector)item;
                    int classPos = 0;
                    while (classPos < simpleItem.getNumOfClasses()) {
                        String name = simpleItem.getClass(classPos);
                        this.selectorNames.add(name);
                        ++classPos;
                    }
                }
                ++itemPos;
            }
            ++selectorPos;
        }
    }

    private Set<String> getSelectorNames() {
        return this.selectorNames;
    }
}

