/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist.computers;

import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.UiBinderXmlModelUtilities;
import com.google.gwt.eclipse.core.uibinder.contentassist.IProposalComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.ReplacementCompletionProposal;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.CssSelectorNameCollector;
import com.google.gwt.eclipse.core.uibinder.sse.css.CssExtractor;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class CssSelectorProposalComputer
implements IProposalComputer {
    private final ICSSModel cssModel;
    private final String enteredSelectorText;
    private final int enteredSelectorTextOffset;

    public static CssSelectorProposalComputer newUsingUiBinderStyleElement(IDOMElement styleElement, String classText, int classTextOffset, IJavaProject javaProject) {
        CssExtractor extractor = UiBinderXmlModelUtilities.createCssExtractorForStyleElement(styleElement, javaProject);
        if (extractor == null) {
            return null;
        }
        return new CssSelectorProposalComputer(extractor.getCssModel(), classText, classTextOffset);
    }

    public CssSelectorProposalComputer(ICSSModel cssModel, String enteredSelectorText, int enteredSelectorTextOffset) {
        this.cssModel = cssModel;
        this.enteredSelectorText = enteredSelectorText;
        this.enteredSelectorTextOffset = enteredSelectorTextOffset;
    }

    @Override
    public void computeProposals(List<ICompletionProposal> proposals) throws UiBinderException {
        for (String selectorName : CssSelectorNameCollector.getLiteralSelectorNames((ICSSNode)this.cssModel.getDocument())) {
            if (!selectorName.startsWith(this.enteredSelectorText)) continue;
            proposals.add(new ReplacementCompletionProposal(selectorName, this.enteredSelectorTextOffset, this.enteredSelectorText.length(), Integer.MIN_VALUE));
        }
    }
}

