/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist.computers;

import com.google.gdt.eclipse.core.contentassist.XmlContentAssistUtilities;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.UiBinderUtilities;
import com.google.gwt.eclipse.core.uibinder.UiBinderXmlModelUtilities;
import com.google.gwt.eclipse.core.uibinder.contentassist.ElExpressionFirstFragmentComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.IProposalComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.ReplacementCompletionProposal;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.CssSelectorProposalComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.JavaElExpressionProposalComputer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ElExpressionProposalComputer
implements IProposalComputer {
    private final Document document;
    private final String elExpressionContents;
    private final int elExpressionContentsOffsetInDocument;
    private final IJavaProject javaProject;

    public static ElExpressionProposalComputer newUsingContentAssistRequest(ContentAssistRequest contentAssistRequest, IJavaProject javaProject) {
        String currentAttrValue = XmlContentAssistUtilities.getAttributeValueUsingMatchString((ContentAssistRequest)contentAssistRequest);
        int currentAttrValueOffset = XmlContentAssistUtilities.getAttributeValueOffset((ContentAssistRequest)contentAssistRequest);
        int elExpressionOffsetInAttrValue = UiBinderUtilities.getOpenElExpressionContentsOffset(currentAttrValue);
        if (elExpressionOffsetInAttrValue == -1) {
            return null;
        }
        return new ElExpressionProposalComputer(currentAttrValue.substring(elExpressionOffsetInAttrValue), currentAttrValueOffset + elExpressionOffsetInAttrValue, contentAssistRequest.getNode().getOwnerDocument(), javaProject);
    }

    public ElExpressionProposalComputer(String elContents, int elContentsOffsetInDocument, Document document, IJavaProject javaProject) {
        this.document = document;
        this.elExpressionContents = elContents;
        this.elExpressionContentsOffsetInDocument = elContentsOffsetInDocument;
        this.javaProject = javaProject;
    }

    @Override
    public void computeProposals(List<ICompletionProposal> proposals) throws UiBinderException {
        Set<ElExpressionFirstFragmentComputer.ElExpressionFirstFragment> matchedFirstFragments = this.findMatchingFirstFragments();
        if (matchedFirstFragments.size() == 0) {
            return;
        }
        if (this.elExpressionContents.indexOf(46) == -1) {
            this.computeProposalsForFirstFragment(proposals, matchedFirstFragments);
        } else {
            this.computeProposalsForDomainSpecificFragments(proposals, matchedFirstFragments);
        }
    }

    private void computeProposalsForDomainSpecificFragments(List<ICompletionProposal> proposals, Set<ElExpressionFirstFragmentComputer.ElExpressionFirstFragment> matchedFirstFragments) throws UiBinderException {
        for (ElExpressionFirstFragmentComputer.ElExpressionFirstFragment firstFragment : matchedFirstFragments) {
            IDOMElement node = (IDOMElement)firstFragment.getNode();
            if (UiBinderXmlModelUtilities.isStyleElement((Node)node)) {
                this.computeProposalsForStyleElement(proposals, (Node)node);
                continue;
            }
            IType javaType = UiBinderXmlModelUtilities.resolveElementToJavaType(node, this.javaProject);
            if (javaType == null) continue;
            this.computeProposalsForJavaType(proposals, javaType);
        }
    }

    private void computeProposalsForFirstFragment(List<ICompletionProposal> proposals, Set<ElExpressionFirstFragmentComputer.ElExpressionFirstFragment> matchedFirstFragments) {
        for (ElExpressionFirstFragmentComputer.ElExpressionFirstFragment matchedFirstFragment : matchedFirstFragments) {
            proposals.add(new ReplacementCompletionProposal(matchedFirstFragment.getValue(), this.elExpressionContentsOffsetInDocument, this.elExpressionContents.length()));
        }
    }

    private void computeProposalsForJavaType(List<ICompletionProposal> proposals, IType javaType) throws UiBinderException {
        JavaElExpressionProposalComputer proposalComputer = JavaElExpressionProposalComputer.newUsingJavaType(javaType, this.getAllButFirstFragment(), this.getAllButFirstFragmentOffset());
        if (proposalComputer != null) {
            proposalComputer.computeProposals(proposals);
        }
    }

    private void computeProposalsForStyleElement(List<ICompletionProposal> proposals, Node node) throws UiBinderException {
        CssSelectorProposalComputer computer = CssSelectorProposalComputer.newUsingUiBinderStyleElement((IDOMElement)node, this.getAllButFirstFragment(), this.getAllButFirstFragmentOffset(), this.javaProject);
        if (computer == null) {
            return;
        }
        computer.computeProposals(proposals);
    }

    private Set<ElExpressionFirstFragmentComputer.ElExpressionFirstFragment> findMatchingFirstFragments() {
        Set<ElExpressionFirstFragmentComputer.ElExpressionFirstFragment> possibleFirstFragments = ElExpressionFirstFragmentComputer.compute(this.document, null, this.javaProject, null).getFirstFragments();
        String enteredFirstFragment = this.getFirstFragment();
        Iterator<ElExpressionFirstFragmentComputer.ElExpressionFirstFragment> it = possibleFirstFragments.iterator();
        while (it.hasNext()) {
            ElExpressionFirstFragmentComputer.ElExpressionFirstFragment possibleFirstFragment = it.next();
            if (possibleFirstFragment.getValue().startsWith(enteredFirstFragment)) continue;
            it.remove();
        }
        return possibleFirstFragments;
    }

    private String getAllButFirstFragment() {
        return this.elExpressionContents.substring(this.getFirstFragment().length() + 1);
    }

    private int getAllButFirstFragmentOffset() {
        return this.elExpressionContentsOffsetInDocument + (this.elExpressionContents.length() - this.getAllButFirstFragment().length());
    }

    private String getFirstFragment() {
        int periodPos = this.elExpressionContents.indexOf(46);
        return periodPos == -1 ? this.elExpressionContents : this.elExpressionContents.substring(0, periodPos);
    }
}

