/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist.computers;

import com.google.gdt.eclipse.core.contentassist.JavaContentAssistUtilities;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.UiBinderUtilities;
import com.google.gwt.eclipse.core.uibinder.contentassist.ReplacementCompletionProposal;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.AbstractJavaProposalComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.ProposalGeneratingCompletionRequestor;
import java.util.List;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class JavaElExpressionProposalComputer
extends AbstractJavaProposalComputer {
    private final IType javaType;

    public static JavaElExpressionProposalComputer newUsingJavaType(IType javaType, String followingText, int followingTextOffset) {
        IType snippetReceivingType = javaType;
        String snippet = followingText;
        int snippetOffset = followingTextOffset;
        int lastPeriodIndex = followingText.lastIndexOf(46);
        if (lastPeriodIndex != -1) {
            String textUntilLastPeriod = followingText.substring(0, lastPeriodIndex);
            snippetReceivingType = UiBinderUtilities.resolveJavaElExpression(javaType, textUntilLastPeriod, null);
            if (snippetReceivingType == null) {
                return null;
            }
            snippet = followingText.substring(lastPeriodIndex + 1);
            snippetOffset = followingTextOffset + lastPeriodIndex + 1;
        }
        return new JavaElExpressionProposalComputer(javaType.getJavaProject(), snippet, snippetOffset, snippet.length(), snippetReceivingType);
    }

    public JavaElExpressionProposalComputer(IJavaProject javaProject, String enteredText, int replaceOffset, int replaceLength, IType javaType) {
        super(javaProject, enteredText, replaceOffset, replaceLength);
        this.javaType = javaType;
    }

    @Override
    public void computeProposals(List<ICompletionProposal> proposals) throws UiBinderException {
        IEvaluationContext evalContext = this.createEvaluationContext();
        try {
            JavaElExpressionCompletionRequestor requestor = new JavaElExpressionCompletionRequestor(6);
            String snippet = String.valueOf(this.javaType.getFullyQualifiedName('.')) + " tmpVar; tmpVar." + this.getEnteredText();
            evalContext.codeComplete(snippet, snippet.length(), (CompletionRequestor)requestor);
            proposals.addAll(requestor.getProposals());
        }
        catch (JavaModelException e) {
            throw new UiBinderException(e);
        }
    }

    @Override
    public IEvaluationContext createEvaluationContext() {
        IEvaluationContext evalContext = super.createEvaluationContext();
        evalContext.setPackageName(this.javaType.getPackageFragment().getElementName());
        return evalContext;
    }

    private class JavaElExpressionCompletionRequestor
    extends ProposalGeneratingCompletionRequestor {
        private final String qualifiedTypeName;

        public JavaElExpressionCompletionRequestor(int ... allowedCompletionTypes) {
            super(JavaElExpressionProposalComputer.this.getReplaceOffset(), JavaElExpressionProposalComputer.this.getReplaceLength(), allowedCompletionTypes, JavaElExpressionProposalComputer.this.getJavaProject(), false);
            this.qualifiedTypeName = JavaElExpressionProposalComputer.this.javaType.getFullyQualifiedName('.');
        }

        @Override
        protected ICompletionProposal createProposal(CompletionProposal javaProposal) {
            char[] signature = javaProposal.getSignature();
            String replacementText = null;
            int relevanceAdjustment = 0;
            if (javaProposal.getKind() != 6) {
                return null;
            }
            if (Signature.getParameterCount((char[])signature) != 0) {
                return null;
            }
            String returnType = String.valueOf(Signature.getReturnType((char[])signature));
            if ("V".equals(returnType)) {
                return null;
            }
            replacementText = String.valueOf(javaProposal.getName());
            IJavaCompletionProposal jdtCompletionProposal = JavaContentAssistUtilities.getJavaCompletionProposal((CompletionProposal)javaProposal, (CompletionContext)this.getContext(), (IJavaProject)JavaElExpressionProposalComputer.this.getJavaProject());
            ReplacementCompletionProposal proposal = ReplacementCompletionProposal.fromExistingCompletionProposal(replacementText, this.getReplaceOffset(), this.getReplaceLength(), (ICompletionProposal)jdtCompletionProposal);
            if ((relevanceAdjustment += this.getRelevanceAdjustmentForMyTypeAndDeclarationType(returnType, javaProposal.getDeclarationSignature())) != 0) {
                proposal.setRelevance(proposal.getRelevance() + relevanceAdjustment);
            }
            return proposal;
        }

        private int getRelevanceAdjustmentForMyTypeAndDeclarationType(String typeSignature, char[] declarationTypeSignature) {
            String qualifiedDeclaringType;
            int relevanceAdjustment = 0;
            if (Signature.toString((String)typeSignature).equals("java.lang.String")) {
                ++relevanceAdjustment;
            }
            if ((qualifiedDeclaringType = String.valueOf(Signature.toCharArray((char[])declarationTypeSignature))).equals(this.qualifiedTypeName)) {
                ++relevanceAdjustment;
            }
            return relevanceAdjustment;
        }
    }
}

