/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist.computers;

import com.google.gdt.eclipse.core.contentassist.JavaContentAssistUtilities;
import com.google.gwt.eclipse.core.uibinder.contentassist.ReplacementCompletionProposal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class ProposalGeneratingCompletionRequestor
extends CompletionRequestor {
    private final boolean forceFullyQualifiedFieldNames;
    private final List<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
    private final int replaceOffset;
    private final int replaceLength;
    private final IJavaProject javaProject;
    private CompletionContext context;

    public ProposalGeneratingCompletionRequestor(int replaceOffset, int replaceLength, int[] allowedCompletionTypes, IJavaProject javaProject, boolean forceFullyQualifiedFieldNames) {
        this.replaceOffset = replaceOffset;
        this.replaceLength = replaceLength;
        this.javaProject = javaProject;
        this.forceFullyQualifiedFieldNames = forceFullyQualifiedFieldNames;
        this.ignoreAll();
        int i = 0;
        while (i < allowedCompletionTypes.length) {
            this.setIgnored(allowedCompletionTypes[i], false);
            ++i;
        }
    }

    public void accept(CompletionProposal proposal) {
        ICompletionProposal createdProposal = this.createProposal(proposal);
        if (createdProposal != null) {
            this.proposals.add(createdProposal);
        }
    }

    public void acceptContext(CompletionContext context) {
        this.context = context;
    }

    public CompletionContext getContext() {
        return this.context;
    }

    public List<ICompletionProposal> getProposals() {
        return this.proposals;
    }

    public int getReplaceLength() {
        return this.replaceLength;
    }

    public int getReplaceOffset() {
        return this.replaceOffset;
    }

    protected ICompletionProposal createProposal(CompletionProposal javaProposal) {
        char[] decSig;
        String completion = String.valueOf(javaProposal.getCompletion());
        int kind = javaProposal.getKind();
        if (kind == 9) {
            completion = JavaContentAssistUtilities.getFullyQualifiedTypeName((CompletionProposal)javaProposal);
        }
        if (this.forceFullyQualifiedFieldNames && (kind == 21 || kind == 2) && (decSig = javaProposal.getDeclarationSignature()) != null && decSig.length > 2) {
            completion = String.valueOf(new String(decSig, 1, decSig.length - 2)) + "." + new String(javaProposal.getCompletion());
            completion = completion.replace('$', '.');
        }
        IJavaCompletionProposal jdtCompletionProposal = JavaContentAssistUtilities.getJavaCompletionProposal((CompletionProposal)javaProposal, (CompletionContext)this.context, (IJavaProject)this.javaProject);
        return ReplacementCompletionProposal.fromExistingCompletionProposal(completion, this.replaceOffset, this.replaceLength, (ICompletionProposal)jdtCompletionProposal);
    }

    private void ignoreAll() {
        int[] ignoredKinds;
        int[] nArray = ignoredKinds = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        int n = ignoredKinds.length;
        int n2 = 0;
        while (n2 < n) {
            int kind = nArray[n2];
            this.setIgnored(kind, true);
            ++n2;
        }
    }
}

