/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist.computers;

import com.google.gdt.eclipse.core.XmlUtilities;
import com.google.gdt.eclipse.core.contentassist.XmlContentAssistUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.contentassist.ReplacementCompletionProposal;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.AbstractJavaProposalComputer;
import java.beans.Introspector;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class SetterAttributeProposalComputer
extends AbstractJavaProposalComputer {
    private static final String DESCRIPTION_FORMAT = "{0}.{1}";
    private static final String SETTER_PREFIX = "set";
    private static final int SETTER_PREFIX_LENGTH = "set".length();
    private static final Set<String> PARSABLE_ARGS = new HashSet<String>(Arrays.asList("boolean", "int", "double", "int,int", Boolean.class.getCanonicalName(), Integer.class.getCanonicalName(), Double.class.getCanonicalName(), String.class.getCanonicalName(), "com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant", "com.google.gwt.user.client.ui.HasVerticalAlignment.VerticalAlignmentConstant", "com.google.gwt.user.client.ui.TextBoxBase.TextAlignConstant", "double,com.google.gwt.dom.client.Style.Unit"));
    private final IDOMNode widgetNode;
    private final String widgetTypeName;

    public SetterAttributeProposalComputer(IDOMNode node, String typeName, IJavaProject javaProject, String enteredText, int replaceOffset, int replaceLength) {
        super(javaProject, enteredText, replaceOffset, replaceLength);
        this.widgetNode = node;
        this.widgetTypeName = typeName;
    }

    @Override
    public void computeProposals(List<ICompletionProposal> completions) {
        HashMap<String, ICompletionProposal> proposals = new HashMap<String, ICompletionProposal>();
        try {
            String name = this.widgetTypeName;
            while (name != null) {
                IType type = this.getJavaProject().findType(name);
                if (type != null) {
                    this.addProposalsFromType(proposals, type);
                    name = type.getSuperclassName();
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e, "Could not generate setter-based attribute proposal.");
        }
        completions.addAll(proposals.values());
    }

    private void addProposal(Map<String, ICompletionProposal> proposals, IType type, IMethod method) {
        String methodName = method.getElementName();
        StringBuffer buf = new StringBuffer();
        buf.append(Introspector.decapitalize(methodName.substring(SETTER_PREFIX_LENGTH)));
        String attributeName = buf.toString();
        buf.append("=\"\"");
        String replacement = buf.toString();
        if (attributeName.startsWith(this.getEnteredText()) && XmlUtilities.getAttribute((Node)this.widgetNode, (String)attributeName, (boolean)true, null) == null && !proposals.containsKey(attributeName)) {
            String description = this.getDescription(type, method);
            ReplacementCompletionProposal completion = new ReplacementCompletionProposal(replacement, this.getReplaceOffset(), this.getReplaceLength(), this.getReplaceOffset() + replacement.length() - 1, description, attributeName, XmlContentAssistUtilities.getImageForAttribute());
            proposals.put(attributeName, completion);
        }
    }

    private void addProposalsFromType(Map<String, ICompletionProposal> proposals, IType type) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (this.isSetterMethod(method) && this.isParsableSetter(method)) {
                this.addProposal(proposals, type, method);
            }
            ++n2;
        }
    }

    private String getDescription(IType type, IMethod method) {
        try {
            return MessageFormat.format(DESCRIPTION_FORMAT, type.getElementName(), Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (boolean)false));
        }
        catch (JavaModelException e) {
            return MessageFormat.format(DESCRIPTION_FORMAT, type.getElementName(), method.getElementName());
        }
    }

    private boolean isParsableSetter(IMethod method) {
        StringBuffer signature = new StringBuffer();
        String[] stringArray = method.getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String qualifier;
            String paramType = stringArray[n2];
            if (signature.length() > 0) {
                signature.append(',');
            }
            if ((qualifier = Signature.getSignatureQualifier((String)paramType)).length() > 0) {
                signature.append(qualifier);
                signature.append('.');
            }
            signature.append(Signature.getSignatureSimpleName((String)paramType));
            ++n2;
        }
        return PARSABLE_ARGS.contains(signature.toString());
    }

    private boolean isSetterMethod(IMethod method) throws JavaModelException {
        String methodName = method.getElementName();
        return methodName.startsWith(SETTER_PREFIX) && methodName.length() > SETTER_PREFIX_LENGTH && Character.isUpperCase(methodName.charAt(SETTER_PREFIX_LENGTH)) && Flags.isPublic((int)method.getFlags()) && !Flags.isStatic((int)method.getFlags()) && "V".equals(method.getReturnType());
    }
}

