/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist.computers;

import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.contentassist.ReplacementCompletionProposal;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.AbstractProposalComputer;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class StaticTextProposalComputer
extends AbstractProposalComputer {
    private final String[] textProposals;
    private final Image image;
    private final boolean isCursorPositionValid;
    private final int cursorPosition;

    public StaticTextProposalComputer(String[] proposals, String enteredText, int replaceOffset, int replaceLength, Image image) {
        super(enteredText, replaceOffset, replaceLength);
        this.textProposals = proposals;
        this.cursorPosition = 0;
        this.isCursorPositionValid = false;
        this.image = image;
    }

    public StaticTextProposalComputer(String[] proposals, String enteredText, int replaceOffset, int replaceLength, int cursorPosition, Image image) {
        super(enteredText, replaceOffset, replaceLength);
        this.textProposals = proposals;
        this.cursorPosition = cursorPosition;
        this.isCursorPositionValid = true;
        this.image = image;
    }

    @Override
    public void computeProposals(List<ICompletionProposal> proposals) throws UiBinderException {
        String[] stringArray = this.textProposals;
        int n = this.textProposals.length;
        int n2 = 0;
        while (n2 < n) {
            String proposal = stringArray[n2];
            if (proposal.startsWith(this.getEnteredText())) {
                proposals.add(this.createProposal(proposal));
            }
            ++n2;
        }
    }

    private ICompletionProposal createProposal(String text) {
        if (this.isCursorPositionValid) {
            return new ReplacementCompletionProposal(text, this.getReplaceOffset(), this.getReplaceLength(), this.cursorPosition, null, text, this.image);
        }
        return new ReplacementCompletionProposal(text, this.getReplaceOffset(), this.getReplaceLength(), Integer.MIN_VALUE, null, text, this.image);
    }
}

