/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist.computers;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.contentassist.XmlContentAssistUtilities;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.UiBinderUtilities;
import com.google.gwt.eclipse.core.uibinder.contentassist.ReplacementCompletionProposal;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.AbstractJavaProposalComputer;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class UiFieldProposalComputer
extends AbstractJavaProposalComputer {
    private final Set<IType> uiBinderTypes;
    private final String widgetTypeName;

    UiFieldProposalComputer(Set<IType> ownerTypes, String widgetTypeName, IJavaProject javaProject, String enteredText, int replaceOffset, int replaceLength) {
        super(javaProject, enteredText, replaceOffset, replaceLength);
        this.uiBinderTypes = ownerTypes;
        this.widgetTypeName = widgetTypeName;
    }

    @Override
    public void computeProposals(List<ICompletionProposal> proposals) throws UiBinderException {
        for (IType uiBinderType : this.uiBinderTypes) {
            IType ownerType = UiBinderUtilities.getOwnerType(uiBinderType);
            TypeDeclaration ownerDecl = JavaASTUtils.findTypeDeclaration((IJavaProject)this.getJavaProject(), (String)ownerType.getFullyQualifiedName('.'));
            if (ownerDecl == null) continue;
            this.addOwnerProposals(proposals, ownerDecl);
        }
    }

    private void addFieldProposal(List<ICompletionProposal> proposals, FieldDeclaration fieldDecl) {
        List fragments = fieldDecl.fragments();
        for (VariableDeclarationFragment fragment : fragments) {
            String fieldName = fragment.getName().getIdentifier();
            if (!fieldName.startsWith(this.getEnteredText())) continue;
            proposals.add(new ReplacementCompletionProposal(fieldName, this.getReplaceOffset(), this.getReplaceLength(), Integer.MIN_VALUE, null, fieldName, XmlContentAssistUtilities.getImageForLocalVariable()));
        }
    }

    private void addOwnerProposals(List<ICompletionProposal> proposals, TypeDeclaration ownerDecl) {
        FieldDeclaration[] fieldDeclarationArray = ownerDecl.getFields();
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDecl = fieldDeclarationArray[n2];
            if (UiBinderUtilities.isUiField(fieldDecl)) {
                ITypeBinding binding = fieldDecl.getType().resolveBinding();
                if (this.widgetTypeName == null || binding == null || this.widgetTypeName.equals(binding.getQualifiedName())) {
                    this.addFieldProposal(proposals, fieldDecl);
                }
            }
            ++n2;
        }
    }
}

