/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.contentassist.computers;

import com.google.gdt.eclipse.core.JavaUtilities;
import com.google.gdt.eclipse.core.XmlUtilities;
import com.google.gdt.eclipse.core.contentassist.JavaContentAssistUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.PackageBasedNamespaceManager;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.contentassist.AbstractCompletionProposal;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.AbstractJavaProposalComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.CodeCompleteProposalComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.ProposalGeneratingCompletionRequestor;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAnyElement;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WidgetProposalComputer
extends AbstractJavaProposalComputer {
    private final Element parentElement;
    private final Element rootElement;
    private final PackageBasedNamespaceManager packageManager = new PackageBasedNamespaceManager();

    public static WidgetProposalComputer newUsingContentAssistRequest(ContentAssistRequest contentAssistRequest, IJavaProject javaProject) {
        short nodeType = contentAssistRequest.getNode().getNodeType();
        if (nodeType != 1 && nodeType != 3) {
            return null;
        }
        IDOMElement rootElement = (IDOMElement)XmlUtilities.getRootElement((Node)contentAssistRequest.getNode());
        if (rootElement == null || javaProject == null) {
            return null;
        }
        if (contentAssistRequest.getStartOffset() <= rootElement.getStartEndOffset()) {
            return null;
        }
        Element parentElement = (Element)(contentAssistRequest.getParent() instanceof Element ? contentAssistRequest.getParent() : null);
        try {
            return new WidgetProposalComputer(contentAssistRequest.getMatchString(), contentAssistRequest.getReplacementBeginPosition(), (Element)rootElement, parentElement, javaProject);
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e, "Could not create the widget proposal computer.");
        }
        catch (UiBinderException e) {
            GWTPluginLog.logError(e, "Could not create the widget proposal computer.");
        }
        return null;
    }

    public WidgetProposalComputer(String text, int offset, Element rootElement, Element parentElement, IJavaProject javaProject) throws JavaModelException, UiBinderException {
        super(javaProject, text, offset, text.length());
        this.rootElement = rootElement;
        this.parentElement = parentElement;
        this.packageManager.readFromElement(rootElement);
    }

    @Override
    public void computeProposals(List<ICompletionProposal> proposals) throws UiBinderException {
        if (!this.isWidgetAllowed()) {
            return;
        }
        IEvaluationContext evalContext = this.createEvaluationContext();
        String packageName = null;
        String prefix = XmlUtilities.getPrefix((String)this.enteredText);
        if (prefix != null && (packageName = this.packageManager.getPackageName(prefix)) == null) {
            return;
        }
        WidgetCompletionRequestor requestor = new WidgetCompletionRequestor(packageName);
        String unprefixedEnteredText = XmlUtilities.getUnprefixed((String)this.enteredText);
        try {
            if (unprefixedEnteredText.trim().length() > 0) {
                evalContext.codeComplete(this.enteredText, this.enteredText.length(), (CompletionRequestor)requestor);
            } else {
                CodeCompleteProposalComputer.completeCodeUsingAlphabet(evalContext, requestor);
            }
            proposals.addAll(requestor.getProposals());
        }
        catch (JavaModelException e) {
            throw new UiBinderException(e);
        }
    }

    private boolean isWidgetAllowed() {
        if (this.parentElement == null) {
            return false;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.rootElement.getOwnerDocument());
        CMElementDeclaration parentCmElementDecl = modelQuery.getCMElementDeclaration(this.parentElement);
        if (parentCmElementDecl == null) {
            return true;
        }
        return CmAnyElementTracker.containsAnyElement(parentCmElementDecl);
    }

    private static class CmAnyElementTracker
    extends CMVisitor {
        private final CMElementDeclaration rootElementDeclaration;
        private boolean anyElementSeen = false;

        public static boolean containsAnyElement(CMElementDeclaration rootElementDecl) {
            CmAnyElementTracker tracker = new CmAnyElementTracker(rootElementDecl);
            tracker.visitCMNode((CMNode)rootElementDecl);
            return tracker.anyElementSeen;
        }

        private CmAnyElementTracker(CMElementDeclaration rootElementDeclaration) {
            this.rootElementDeclaration = rootElementDeclaration;
        }

        public void visitCMAnyElement(CMAnyElement anyElement) {
            this.anyElementSeen = true;
        }

        public void visitCMElementDeclaration(CMElementDeclaration elementDeclaration) {
            if (elementDeclaration.equals(this.rootElementDeclaration)) {
                super.visitCMElementDeclaration(elementDeclaration);
            }
        }
    }

    private class WidgetCompletionRequestor
    extends ProposalGeneratingCompletionRequestor {
        private final String packageName;

        public WidgetCompletionRequestor(String packageName) {
            super(WidgetProposalComputer.this.getReplaceOffset(), WidgetProposalComputer.this.getEnteredText().length(), new int[]{9}, WidgetProposalComputer.this.getJavaProject(), false);
            this.packageName = packageName;
        }

        @Override
        protected ICompletionProposal createProposal(CompletionProposal proposal) {
            if (proposal.getKind() != 9) {
                return null;
            }
            String qualifiedTypeName = String.valueOf(Signature.toCharArray((char[])proposal.getSignature()));
            String typePackage = JavaUtilities.getPackageName((String)qualifiedTypeName);
            String typeSimpleName = Signature.getSimpleName((String)qualifiedTypeName);
            if (this.packageName != null && !typePackage.equals(this.packageName)) {
                return null;
            }
            IJavaCompletionProposal javaCompletionProposal = JavaContentAssistUtilities.getJavaCompletionProposal((CompletionProposal)proposal, (CompletionContext)this.getContext(), (IJavaProject)WidgetProposalComputer.this.getJavaProject());
            if (javaCompletionProposal != null) {
                return new WidgetProposal(typeSimpleName, typePackage, null, javaCompletionProposal.getDisplayString(), javaCompletionProposal.getImage(), this.getReplaceOffset(), this.getReplaceLength(), WidgetProposalComputer.this.packageManager);
            }
            return new WidgetProposal(typeSimpleName, typePackage, null, typeSimpleName, null, this.getReplaceOffset(), this.getReplaceLength(), WidgetProposalComputer.this.packageManager);
        }
    }

    private static class WidgetProposal
    extends AbstractCompletionProposal {
        private final String simpleTypeName;
        private final String packageName;
        private int startPosition;
        private int cursorPosition;
        private boolean wasLinkedModeEntered;
        private int replaceLength;
        private final PackageBasedNamespaceManager packageManager;

        public WidgetProposal(String simpleTypeName, String packageName, String additionalInfo, String displayString, Image image, int replaceOffset, int replaceLength, PackageBasedNamespaceManager packageManager) {
            super(additionalInfo, displayString, image);
            this.simpleTypeName = simpleTypeName;
            this.packageName = packageName;
            this.startPosition = replaceOffset;
            this.replaceLength = replaceLength;
            this.packageManager = packageManager;
        }

        @Override
        public Point getSelection(IDocument document) {
            return this.wasLinkedModeEntered ? null : new Point(this.cursorPosition, 0);
        }

        @Override
        public void onApply(IDocument document, ITextViewer viewer) throws BadLocationException {
            IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForEdit(document);
            if (model == null) {
                return;
            }
            try {
                this.apply(document, viewer, (IDOMElement)model.getDocument().getDocumentElement());
            }
            finally {
                model.releaseFromEdit();
            }
        }

        private void apply(IDocument document, ITextViewer viewer, IDOMElement rootElement) throws BadLocationException {
            boolean isAlreadyImported;
            String prefix = this.packageManager.getPrefix(this.packageName);
            boolean bl = isAlreadyImported = prefix != null;
            if (!isAlreadyImported) {
                prefix = this.packageManager.resolvePrefix(this.packageName);
                int oldDocumentLength = document.getLength();
                this.packageManager.writeToElement((Element)rootElement);
                this.startPosition += document.getLength() - oldDocumentLength;
            }
            String prefixedElementName = MessageFormat.format("{0}:{1}", prefix, this.simpleTypeName);
            String replacementText = MessageFormat.format("{0}></{0}>", prefixedElementName);
            document.replace(this.startPosition, this.replaceLength, replacementText);
            this.cursorPosition = this.startPosition + prefixedElementName.length() + 1;
            if (!isAlreadyImported && viewer != null) {
                this.enterLinkedModeForPrefix(document, viewer, rootElement, prefix);
            }
        }

        private void enterLinkedModeForPrefix(IDocument document, ITextViewer viewer, IDOMElement rootElement, String prefix) throws BadLocationException {
            int linkedPosSequence = 0;
            LinkedPosition pos1 = new LinkedPosition(document, this.startPosition, prefix.length(), linkedPosSequence++);
            LinkedPosition pos2 = new LinkedPosition(document, this.cursorPosition + 2, prefix.length(), linkedPosSequence++);
            IDOMElement rootDomElement = rootElement;
            String xmlnsPrefix = "xmlns:";
            String fullPrefixName = "xmlns:" + prefix;
            IDOMAttr domAttribute = (IDOMAttr)rootDomElement.getAttributeNode(fullPrefixName);
            LinkedPosition pos3 = new LinkedPosition(document, domAttribute.getStartOffset() + "xmlns:".length(), prefix.length(), linkedPosSequence++);
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(pos1);
            group.addPosition(pos2);
            group.addPosition(pos3);
            LinkedModeModel model = new LinkedModeModel();
            model.addGroup(group);
            model.forceInstall();
            LinkedModeUI ui = new LinkedModeUI(model, viewer);
            ui.enter();
            this.wasLinkedModeEntered = true;
        }
    }
}

