/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.formatter;

import com.google.gdt.eclipse.core.XmlUtilities;
import com.google.gdt.eclipse.core.formatter.IDocumentCloner;
import com.google.gdt.eclipse.core.formatter.IndependentMultiPassContentFormatter;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.sse.StructuredTextPartitionerForUiBinderXml;
import com.google.gwt.eclipse.core.uibinder.sse.css.InlinedCssFormattingStrategy;
import com.google.gwt.eclipse.core.uibinder.text.IDocumentPartitionerFactory;
import com.google.gwt.eclipse.core.uibinder.text.StructuredDocumentCloner;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.ui.internal.XMLFormattingStrategy;

public final class UiBinderFormatter {
    private static final IDocumentPartitionerFactory UIBINDER_XML_PARTITIONER_FACTORY = new IDocumentPartitionerFactory(){

        @Override
        public IDocumentPartitioner createDocumentPartitioner() {
            return new StructuredTextPartitionerForUiBinderXml();
        }
    };

    public static IContentFormatter createFormatter(String partitioning) {
        IndependentMultiPassContentFormatter formatter = new IndependentMultiPassContentFormatter(partitioning, "org.eclipse.wst.xml.XML_DEFAULT", (IDocumentCloner)new StructuredDocumentCloner(partitioning, UIBINDER_XML_PARTITIONER_FACTORY));
        formatter.setMasterStrategy((IFormattingStrategy)new XMLFormattingStrategy());
        formatter.setSlaveStrategy2((IFormattingStrategy)new InlinedCssFormattingStrategy(), "org.eclipse.wst.css.STYLE");
        formatter.setReplaceSlavePartitionsDuringMasterFormat(true);
        formatter.setCheckForNonwhitespaceChanges(true);
        return formatter;
    }

    public static void format(IFile uiXmlFile, boolean forceSave) throws UiBinderException {
        final IContentFormatter formatter = UiBinderFormatter.createFormatter("org.eclipse.wst.sse.core.default_structured_text_partitioning");
        try {
            new XmlUtilities.EditOperation(uiXmlFile){

                protected void edit(IDOMDocument document) {
                    IStructuredDocument doc = document.getModel().getStructuredDocument();
                    formatter.format((IDocument)doc, (IRegion)new Region(0, doc.getLength()));
                }
            }.run(forceSave);
        }
        catch (IOException e) {
            throw new UiBinderException(e);
        }
        catch (CoreException e) {
            throw new UiBinderException(e);
        }
    }

    private UiBinderFormatter() {
    }
}

