/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.model;

import com.google.gdt.eclipse.core.CorePluginLog;
import com.google.gdt.eclipse.core.JavaUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gdt.eclipse.core.reference.PersistenceException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IMemento;

public class UiBinderSubtypeToOwnerIndex {
    private static final String KEY_UIBINDER_SUBTYPE_AND_OWNER_ENTRY = "entry";
    private final Map<IType, String> uiBinderToOwnerClass;

    public static UiBinderSubtypeToOwnerIndex load(IMemento memento) throws PersistenceException {
        UiBinderSubtypeToOwnerIndex index = new UiBinderSubtypeToOwnerIndex();
        boolean hadException = false;
        IMemento[] iMementoArray = memento.getChildren(KEY_UIBINDER_SUBTYPE_AND_OWNER_ENTRY);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento childMemento = iMementoArray[n2];
            try {
                UiBinderSubtypeAndOwner subtypeAndOwner = UiBinderSubtypeAndOwner.load(childMemento);
                if (subtypeAndOwner != null) {
                    index.setOwnerType(subtypeAndOwner);
                }
            }
            catch (PersistenceException e) {
                CorePluginLog.logError((Throwable)e, (String)"Error loading persisted index entry.");
                hadException = true;
            }
            ++n2;
        }
        if (hadException) {
            throw new PersistenceException("Error loading all the references, check log for more details.");
        }
        return index;
    }

    public UiBinderSubtypeToOwnerIndex() {
        this.uiBinderToOwnerClass = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiBinderSubtypeToOwnerIndex(UiBinderSubtypeToOwnerIndex original) {
        Map<IType, String> map = original.uiBinderToOwnerClass;
        synchronized (map) {
            this.uiBinderToOwnerClass = Collections.synchronizedMap(new HashMap<IType, String>(original.uiBinderToOwnerClass));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(IProject project) {
        HashSet<IType> uiBinderTypes;
        Map<IType, String> map = this.uiBinderToOwnerClass;
        synchronized (map) {
            uiBinderTypes = new HashSet<IType>(this.uiBinderToOwnerClass.keySet());
        }
        for (IType uiBinderType : uiBinderTypes) {
            if (!uiBinderType.getJavaProject().getProject().equals((Object)project)) continue;
            this.removeUiBinderType(uiBinderType);
        }
    }

    public boolean containsOwnerType(String typeName) {
        return this.uiBinderToOwnerClass.containsValue(typeName);
    }

    public boolean containsUiBinderType(IType type) {
        return this.uiBinderToOwnerClass.containsKey(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllOwnerTypeNames() {
        Map<IType, String> map = this.uiBinderToOwnerClass;
        synchronized (map) {
            return Collections.unmodifiableSet(new HashSet<String>(this.uiBinderToOwnerClass.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IType> getAllUiBinderTypes() {
        Map<IType, String> map = this.uiBinderToOwnerClass;
        synchronized (map) {
            return Collections.unmodifiableSet(new HashSet<IType>(this.uiBinderToOwnerClass.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UiBinderSubtypeAndOwner> getAllUiBinderTypesAndOwners() {
        HashSet<UiBinderSubtypeAndOwner> entries = new HashSet<UiBinderSubtypeAndOwner>();
        Map<IType, String> map = this.uiBinderToOwnerClass;
        synchronized (map) {
            for (Map.Entry<IType, String> mapEntry : this.uiBinderToOwnerClass.entrySet()) {
                entries.add(new UiBinderSubtypeAndOwner(mapEntry.getKey(), mapEntry.getValue()));
            }
        }
        return entries;
    }

    public String getOwnerTypeName(IType uiBinderType) {
        return this.uiBinderToOwnerClass.get(uiBinderType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IType> getUiBinderTypes(String ownerType) {
        HashSet<IType> uiBinderTypes = new HashSet<IType>();
        Map<IType, String> map = this.uiBinderToOwnerClass;
        synchronized (map) {
            for (IType uiBinderType : this.uiBinderToOwnerClass.keySet()) {
                if (!this.uiBinderToOwnerClass.get(uiBinderType).equals(ownerType)) continue;
                uiBinderTypes.add(uiBinderType);
            }
        }
        return uiBinderTypes;
    }

    public boolean isOwnerType(String type) {
        return this.uiBinderToOwnerClass.containsValue(type);
    }

    public void persist(IMemento memento) {
        for (UiBinderSubtypeAndOwner pair : this.getAllUiBinderTypesAndOwners()) {
            pair.persist(memento.createChild(KEY_UIBINDER_SUBTYPE_AND_OWNER_ENTRY));
        }
    }

    public void removeUiBinderType(IType uiBinderType) {
        this.uiBinderToOwnerClass.remove(uiBinderType);
    }

    public void setOwnerType(IType uiBinderType, String ownerType) {
        this.uiBinderToOwnerClass.put(uiBinderType, ownerType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (UiBinderSubtypeAndOwner entry : this.getAllUiBinderTypesAndOwners()) {
            sb.append(entry.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    private void setOwnerType(UiBinderSubtypeAndOwner pair) {
        this.setOwnerType(pair.getUiBinderType(), pair.getOwnerTypeName());
    }

    public static final class UiBinderSubtypeAndOwner {
        private static final String KEY_OWNER_TYPE_NAME = "owner";
        private static final String KEY_UIBINDER_SUBTYPE = "uiBinder";
        private final String ownerTypeName;
        private final IType uiBinderType;

        public static UiBinderSubtypeAndOwner load(IMemento memento) throws PersistenceException {
            String ownerTypeName = memento.getString(KEY_OWNER_TYPE_NAME);
            if (ownerTypeName == null) {
                throw new PersistenceException("Missing key owner");
            }
            String uiBinderSubtypeKey = memento.getString(KEY_UIBINDER_SUBTYPE);
            if (uiBinderSubtypeKey == null) {
                throw new PersistenceException("Missing key uiBinder");
            }
            IJavaElement javaElement = JavaCore.create((String)uiBinderSubtypeKey);
            if (javaElement == null) {
                throw new PersistenceException("Could not create type " + uiBinderSubtypeKey);
            }
            if (!(javaElement instanceof IType)) {
                throw new PersistenceException("Expecting " + javaElement.getElementName() + " to be a type");
            }
            if (!javaElement.getJavaProject().isOpen()) {
                return null;
            }
            if (!JavaModelSearch.isValidElement((IJavaElement)javaElement)) {
                throw new PersistenceException(String.valueOf(((IType)javaElement).getFullyQualifiedName()) + " is not a valid Java type");
            }
            return new UiBinderSubtypeAndOwner((IType)javaElement, ownerTypeName);
        }

        private UiBinderSubtypeAndOwner(IType uiBinderType, String ownerTypeName) {
            this.uiBinderType = uiBinderType;
            this.ownerTypeName = ownerTypeName;
        }

        public IType findOwnerType() {
            return JavaModelSearch.findType((IJavaProject)this.uiBinderType.getJavaProject(), (String)this.ownerTypeName);
        }

        public String getOwnerTypeName() {
            return this.ownerTypeName;
        }

        public IType getUiBinderType() {
            return this.uiBinderType;
        }

        public boolean hasCommonCompilationUnit() {
            IType ownerType = this.findOwnerType();
            if (ownerType == null) {
                return false;
            }
            return JavaUtilities.equalsWithNullCheck((Object)this.uiBinderType.getCompilationUnit(), (Object)ownerType.getCompilationUnit());
        }

        public void persist(IMemento memento) {
            memento.putString(KEY_OWNER_TYPE_NAME, this.ownerTypeName);
            memento.putString(KEY_UIBINDER_SUBTYPE, this.uiBinderType.getHandleIdentifier());
        }

        public String toString() {
            return MessageFormat.format("{0} -> {1}", this.uiBinderType.getFullyQualifiedName(), this.ownerTypeName);
        }
    }
}

