/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.model;

import com.google.gdt.eclipse.core.CorePluginLog;
import com.google.gdt.eclipse.core.collections.OneToManyIndex;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gdt.eclipse.core.reference.PersistenceException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IMemento;

public class UiBinderSubtypeToUiXmlIndex {
    private static final String KEY_UI_XML_PATH = "uiXmlPath";
    private static final String KEY_UIBINDER_SUBTYPE = "uiBinder";
    private static final String KEY_UIBINDER_SUBTYPE_AND_UI_XML_ENTRY = "entry";
    private final OneToManyIndex<IPath, IType> uiXmlPathToOwnerTypes;

    public static UiBinderSubtypeToUiXmlIndex load(IMemento memento) throws PersistenceException {
        UiBinderSubtypeToUiXmlIndex index = new UiBinderSubtypeToUiXmlIndex();
        boolean hadException = false;
        IMemento[] iMementoArray = memento.getChildren(KEY_UIBINDER_SUBTYPE_AND_UI_XML_ENTRY);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento childMemento = iMementoArray[n2];
            try {
                UiBinderSubtypeToUiXmlIndex.loadEntry(childMemento, index);
            }
            catch (PersistenceException e) {
                CorePluginLog.logError((Throwable)e, (String)"Error loading persisted index entry.");
                hadException = true;
            }
            ++n2;
        }
        if (hadException) {
            throw new PersistenceException("Error loading all the references, check log for more details.");
        }
        return index;
    }

    private static void loadEntry(IMemento memento, UiBinderSubtypeToUiXmlIndex index) throws PersistenceException {
        String uiXmlPath = memento.getString(KEY_UI_XML_PATH);
        if (uiXmlPath == null) {
            throw new PersistenceException("Missing key uiXmlPath");
        }
        String uiBinderSubtypeKey = memento.getString(KEY_UIBINDER_SUBTYPE);
        if (uiBinderSubtypeKey == null) {
            throw new PersistenceException("Missing key uiBinder");
        }
        IJavaElement javaElement = JavaCore.create((String)uiBinderSubtypeKey);
        if (javaElement == null) {
            throw new PersistenceException("Could not create Java element with key " + uiBinderSubtypeKey);
        }
        if (!(javaElement instanceof IType)) {
            throw new PersistenceException("Expecting " + javaElement.getElementName() + " to be a type");
        }
        if (!javaElement.getJavaProject().isOpen()) {
            return;
        }
        if (!JavaModelSearch.isValidElement((IJavaElement)javaElement)) {
            throw new PersistenceException(String.valueOf(((IType)javaElement).getFullyQualifiedName()) + " is not a valid Java type");
        }
        index.setUiXmlPath((IType)javaElement, (IPath)new Path(uiXmlPath));
    }

    public UiBinderSubtypeToUiXmlIndex() {
        this.uiXmlPathToOwnerTypes = new OneToManyIndex();
    }

    public UiBinderSubtypeToUiXmlIndex(UiBinderSubtypeToUiXmlIndex original) {
        this.uiXmlPathToOwnerTypes = new OneToManyIndex(original.uiXmlPathToOwnerTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(IProject project) {
        UiBinderSubtypeToUiXmlIndex uiBinderSubtypeToUiXmlIndex = this;
        synchronized (uiBinderSubtypeToUiXmlIndex) {
            for (IType uiBinderType : this.uiXmlPathToOwnerTypes.elements()) {
                if (!uiBinderType.getJavaProject().getProject().equals((Object)project)) continue;
                this.removeUiBinderSubtype(uiBinderType);
            }
        }
    }

    public Set<IType> getUiBinderSubtypes(IPath uiXmlPath) {
        return this.uiXmlPathToOwnerTypes.getElements((Object)uiXmlPath);
    }

    public IPath getUiXmlPath(IType uiBinderSubtype) {
        Set uiXmls = this.uiXmlPathToOwnerTypes.getKeys((Object)uiBinderSubtype);
        if (uiXmls.isEmpty()) {
            return null;
        }
        return (IPath)uiXmls.iterator().next();
    }

    public void persist(IMemento memento) {
        for (IPath uiXmlPath : this.getAllUiXmlPaths()) {
            for (IType uiBinderSubtype : this.getUiBinderSubtypes(uiXmlPath)) {
                this.persistEntry(memento.createChild(KEY_UIBINDER_SUBTYPE_AND_UI_XML_ENTRY), uiBinderSubtype, uiXmlPath);
            }
        }
    }

    public void removeUiBinderSubtype(IType uiBinderSubtype) {
        this.uiXmlPathToOwnerTypes.removeElement((Object)uiBinderSubtype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUiXmlPath(IType uiBinderSubtype, IPath uiXmlPath) {
        UiBinderSubtypeToUiXmlIndex uiBinderSubtypeToUiXmlIndex = this;
        synchronized (uiBinderSubtypeToUiXmlIndex) {
            this.uiXmlPathToOwnerTypes.removeElement((Object)uiBinderSubtype);
            this.uiXmlPathToOwnerTypes.addElement((Object)uiXmlPath, (Object)uiBinderSubtype);
        }
    }

    private Set<IPath> getAllUiXmlPaths() {
        return this.uiXmlPathToOwnerTypes.keys();
    }

    private void persistEntry(IMemento memento, IType uiBinderSubtype, IPath uiXmlPath) {
        memento.putString(KEY_UIBINDER_SUBTYPE, uiBinderSubtype.getHandleIdentifier());
        memento.putString(KEY_UI_XML_PATH, uiXmlPath.toString());
    }
}

