/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.model;

import com.google.gdt.eclipse.core.CorePluginLog;
import com.google.gdt.eclipse.core.collections.OneToManyIndex;
import com.google.gdt.eclipse.core.reference.PersistenceException;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.ui.IMemento;

public final class UiXmlReferencedFieldIndex {
    private static final String KEY_FIELD_NAME = "name";
    private static final String KEY_UI_FIELD_REF = "uiField";
    private static final String KEY_UI_XML_PATH = "location";
    private final OneToManyIndex<IPath, String> referencedFields = new OneToManyIndex();

    public static UiXmlReferencedFieldIndex load(IMemento memento) throws PersistenceException {
        UiXmlReferencedFieldIndex index = new UiXmlReferencedFieldIndex();
        boolean hadException = false;
        IMemento[] iMementoArray = memento.getChildren(KEY_UI_FIELD_REF);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento childMemento = iMementoArray[n2];
            try {
                UiXmlReferencedFieldIndex.loadFieldRef(childMemento, index);
            }
            catch (PersistenceException e) {
                CorePluginLog.logError((Throwable)e, (String)"Error loading persisted index entry.");
                hadException = true;
            }
            ++n2;
        }
        if (hadException) {
            throw new PersistenceException("Error loading all the references, check log for more details.");
        }
        return index;
    }

    private static void loadFieldRef(IMemento refMemento, UiXmlReferencedFieldIndex index) throws PersistenceException {
        String uiXmlPath = refMemento.getString(KEY_UI_XML_PATH);
        if (uiXmlPath == null) {
            throw new PersistenceException("Missing key location");
        }
        String fieldName = refMemento.getString(KEY_FIELD_NAME);
        if (fieldName == null) {
            throw new PersistenceException("Missing key name");
        }
        index.addFieldReference((IPath)new Path(uiXmlPath), fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(IJavaProject javaProject) {
        UiXmlReferencedFieldIndex uiXmlReferencedFieldIndex = this;
        synchronized (uiXmlReferencedFieldIndex) {
            for (IPath uiXmlPath : this.referencedFields.keys()) {
                IResource uiXmlResource = ResourcesPlugin.getWorkspace().getRoot().findMember(uiXmlPath);
                if (uiXmlResource == null || !uiXmlResource.getProject().equals((Object)javaProject.getProject())) continue;
                this.remove(uiXmlPath);
            }
        }
    }

    public boolean hasUiXml(IPath uiXmlPath) {
        return this.referencedFields.hasKey((Object)uiXmlPath);
    }

    public boolean isFieldReferencedByUiXml(IPath uiXmlPath, String fieldName) {
        return this.referencedFields.getElements((Object)uiXmlPath).contains(fieldName);
    }

    public void persist(IMemento memento) {
        for (IPath uiXmlPath : this.getAllUiXmlPaths()) {
            for (String fieldName : this.getFieldReferences(uiXmlPath)) {
                this.persistReference(memento.createChild(KEY_UI_FIELD_REF), uiXmlPath, fieldName);
            }
        }
    }

    public void putFieldReferencesForUiXml(IPath uiXmlPath, Set<String> fieldNames) {
        this.referencedFields.putElements((Object)uiXmlPath, fieldNames);
    }

    public void remove(IPath uiXmlPath) {
        this.referencedFields.removeKey((Object)uiXmlPath);
    }

    private void addFieldReference(IPath uiXmlPath, String fieldName) {
        this.referencedFields.addElement((Object)uiXmlPath, (Object)fieldName);
    }

    private Set<IPath> getAllUiXmlPaths() {
        return this.referencedFields.keys();
    }

    private Set<String> getFieldReferences(IPath uiXmlPath) {
        return this.referencedFields.getElements((Object)uiXmlPath);
    }

    private void persistReference(IMemento memento, IPath uiXmlPath, String fieldName) {
        memento.putString(KEY_UI_XML_PATH, uiXmlPath.toString());
        memento.putString(KEY_FIELD_NAME, fieldName);
    }
}

