/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.model.reference;

import com.google.gdt.eclipse.core.BuilderUtilities;
import com.google.gdt.eclipse.core.JavaUtilities;
import com.google.gdt.eclipse.core.SseUtilities;
import com.google.gdt.eclipse.core.java.ClasspathResourceUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gdt.eclipse.core.reference.IReference;
import com.google.gdt.eclipse.core.reference.ReferenceManager;
import com.google.gdt.eclipse.core.reference.location.ClasspathRelativeFileReferenceLocation;
import com.google.gdt.eclipse.core.reference.location.IReferenceLocation;
import com.google.gdt.eclipse.core.reference.location.LogicalJavaElementReferenceLocation;
import com.google.gdt.eclipse.core.reference.logicaljavamodel.ILogicalJavaElement;
import com.google.gdt.eclipse.core.reference.logicaljavamodel.LogicalType;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.model.reference.UiBinderReferenceManager;
import com.google.gwt.eclipse.core.uibinder.model.reference.UiBinderXmlParser;
import com.google.gwt.eclipse.core.uibinder.problems.MarkerPlacementStrategy;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ReferenceRefresher {
    private final ReferenceManager referenceManager;

    public ReferenceRefresher(ReferenceManager referenceManager) {
        this.referenceManager = referenceManager;
    }

    public void refreshReference(IReference reference) throws UiBinderException {
        IReferenceLocation srcLocation = reference.getSourceLocation();
        IProject project = reference.getSourceProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            throw new UiBinderException("The Java project could not be found for the reference.");
        }
        if (srcLocation instanceof ClasspathRelativeFileReferenceLocation) {
            try {
                this.refreshUiXml((ClasspathRelativeFileReferenceLocation)srcLocation, javaProject);
            }
            catch (JavaModelException e) {
                throw new UiBinderException(e);
            }
        } else if (srcLocation instanceof LogicalJavaElementReferenceLocation) {
            this.refreshLogicalJavaElement((LogicalJavaElementReferenceLocation)srcLocation);
        }
    }

    private void logCouldNotRefreshResource(Throwable t, IResource resource) {
        GWTPluginLog.logError(t, "Could not refresh the references on the {0}", resource.getLocation().toOSString());
    }

    private void refreshLogicalJavaElement(LogicalJavaElementReferenceLocation location) {
        ILogicalJavaElement logicalJavaElement = location.getLogicalJavaElement();
        if (!(logicalJavaElement instanceof LogicalType)) {
            return;
        }
        IJavaProject project = JavaCore.create((IProject)location.getReference().getSourceProject());
        assert (project != null);
        LogicalType logicalType = (LogicalType)logicalJavaElement;
        try {
            ICompilationUnit compilationUnit;
            IType type = logicalType.getType(project);
            if (!JavaModelSearch.isValidElement((IJavaElement)type)) {
                return;
            }
            HashSet<ICompilationUnit> compilationUnits = new HashSet<ICompilationUnit>();
            String ownerTypeName = UiBinderReferenceManager.INSTANCE.getSubtypeToOwnerIndex().getOwnerTypeName(type);
            if (ownerTypeName != null) {
                ICompilationUnit compilationUnit2;
                IType ownerType = JavaModelSearch.findType((IJavaProject)type.getJavaProject(), (String)ownerTypeName);
                if (JavaModelSearch.isValidElement((IJavaElement)ownerType) && JavaModelSearch.isValidElement((IJavaElement)(compilationUnit2 = ownerType.getCompilationUnit()))) {
                    compilationUnits.add(compilationUnit2);
                }
            } else {
                GWTPluginLog.logWarning(new Exception(), MessageFormat.format("Could not find owner type for {0}", type.getElementName()));
            }
            if (JavaModelSearch.isValidElement((IJavaElement)(compilationUnit = type.getCompilationUnit()))) {
                compilationUnits.add(compilationUnit);
            }
            if (compilationUnits.size() > 0) {
                BuilderUtilities.revalidateCompilationUnits(compilationUnits, (String)"Revalidating UiBinder subtype");
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logWarning(e, "Could not force revalidation of " + logicalType.getFullyQualifiedName());
        }
    }

    private void refreshUiXml(ClasspathRelativeFileReferenceLocation location, IJavaProject javaProject) throws JavaModelException {
        IPath uiXmlPath = location.getClasspathRelativePath();
        String packageName = JavaUtilities.getPackageNameFromPath((IPath)uiXmlPath.removeLastSegments(1));
        for (IPackageFragment pckgFragment : JavaModelSearch.getPackageFragments((IJavaProject)javaProject, (String)packageName)) {
            IStorage uiXmlRes = ClasspathResourceUtilities.resolveFileOnPackageFragment((String)uiXmlPath.lastSegment(), (IPackageFragment)pckgFragment);
            if (!(uiXmlRes instanceof IFile)) continue;
            this.refreshUiXml((IFile)uiXmlRes);
        }
    }

    private void refreshUiXml(final IFile uiXmlFile) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ReferenceRefresher.this.refreshUiXmlUnsafe(uiXmlFile);
                }
            }, (ISchedulingRule)uiXmlFile, 0, null);
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e, "Could not refresh {0}.", uiXmlFile.getLocation().toOSString());
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshUiXmlUnsafe(IFile uiXmlFile) {
        IDOMModel xmlModel = null;
        try {
            try {
                xmlModel = SseUtilities.getModelForRead((IResource)uiXmlFile);
                if (xmlModel == null) return;
                UiBinderXmlParser.newInstance(xmlModel, this.referenceManager, new MarkerPlacementStrategy("com.gwtplugins.gwt.eclipse.core.uiBinderProblemMarker")).parse();
                return;
            }
            catch (IOException e) {
                this.logCouldNotRefreshResource(e, (IResource)uiXmlFile);
                if (xmlModel == null) return;
                xmlModel.releaseFromRead();
                return;
            }
            catch (CoreException e) {
                this.logCouldNotRefreshResource(e, (IResource)uiXmlFile);
                if (xmlModel == null) return;
                xmlModel.releaseFromRead();
                return;
            }
            catch (UiBinderException e) {
                this.logCouldNotRefreshResource(e, (IResource)uiXmlFile);
                if (xmlModel == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                xmlModel.releaseFromRead();
                return;
            }
        }
        finally {
            if (xmlModel != null) {
                xmlModel.releaseFromRead();
            }
        }
    }
}

