/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.model.reference;

import com.google.gdt.eclipse.core.MarkerUtilities;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gdt.eclipse.core.reference.IReference;
import com.google.gdt.eclipse.core.reference.PersistenceException;
import com.google.gdt.eclipse.core.reference.ReferenceManager;
import com.google.gdt.eclipse.core.reference.location.ReferenceLocationType;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.model.UiBinderSubtypeToOwnerIndex;
import com.google.gwt.eclipse.core.uibinder.model.UiBinderSubtypeToUiXmlIndex;
import com.google.gwt.eclipse.core.uibinder.model.UiXmlReferencedFieldIndex;
import com.google.gwt.eclipse.core.uibinder.model.reference.ReferenceRefresher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public enum UiBinderReferenceManager {
    INSTANCE;

    private static final String KEY_REFERENCE_MANAGER = "referenceManager";
    private static final String KEY_ROOT = "uiBinderReferences";
    private static final String KEY_UI_XML_REF_FIELDS = "uiXmlReferencedFields";
    private static final String KEY_UIBINDER_SUBTYPE_OWNER = "uiBinderSubtypeToOwner";
    private static final String KEY_UIBINDER_SUBTYPE_UI_XML = "uiBinderSubtypeToUiXml";
    private final ReferenceManager.ReferenceChangeListener referenceChangeListener = new ReferenceManager.ReferenceChangeListener(){

        public void referencedJavaElementChanged(Map<IJavaElement, IJavaElementDelta> changedElements) {
            HashSet<IReference> allReferencesToRefresh = new HashSet<IReference>();
            for (IJavaElement changedElement : changedElements.keySet()) {
                Set referencesToRefresh = UiBinderReferenceManager.this.referenceManager.getReferencesWithMatchingJavaElement(changedElement, EnumSet.of(ReferenceLocationType.TARGET));
                for (IReference ref : referencesToRefresh) {
                    allReferencesToRefresh.add(ref);
                }
            }
            this.scheduleJobToRefresh(allReferencesToRefresh);
        }

        public void referencedResourceChanged(Map<IResource, IResourceDelta> changedResources) {
            HashSet<IReference> allReferencesToRefresh = new HashSet<IReference>();
            for (IResource changedResource : changedResources.keySet()) {
                IResourceDelta delta = changedResources.get(changedResource);
                int flags = delta.getFlags();
                int kind = delta.getKind();
                if (kind != 1 && kind != 2 && (flags & 0x100) == 0 && (flags & 0x4000) == 0) continue;
                Set referencesToRefresh = UiBinderReferenceManager.this.referenceManager.getReferencesWithMatchingResource(changedResource, EnumSet.of(ReferenceLocationType.TARGET));
                for (IReference referenceToRefresh : referencesToRefresh) {
                    allReferencesToRefresh.add(referenceToRefresh);
                }
            }
            this.scheduleJobToRefresh(allReferencesToRefresh);
        }

        private void scheduleJobToRefresh(final HashSet<IReference> references) {
            WorkspaceJob refreshJob = new WorkspaceJob("Refreshing references"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    try {
                        for (IReference ref : references) {
                            UiBinderReferenceManager.this.referenceRefresher.refreshReference(ref);
                        }
                    }
                    catch (UiBinderException e) {
                        GWTPluginLog.logError(e, "Could not refresh the source of a reference");
                    }
                    return StatusUtilities.OK_STATUS;
                }
            };
            refreshJob.setRule(null);
            refreshJob.schedule();
        }
    };
    private ReferenceManager referenceManager;
    private ReferenceRefresher referenceRefresher;
    private UiBinderSubtypeToOwnerIndex subtypeToOwnerIndex;
    private UiBinderSubtypeToUiXmlIndex subtypeToUiXmlIndex;
    private final IElementChangedListener uiBinderSubtypePurger = new IElementChangedListener(){
        private final JavaModelSearch.IJavaElementDeltaVisitor visitor = new JavaModelSearch.IJavaElementDeltaVisitor(){

            public boolean visit(IJavaElementDelta delta) {
                IJavaElement element = delta.getElement();
                if (element instanceof ICompilationUnit) {
                    ICompilationUnit cu = (ICompilationUnit)element;
                    for (IType uiBinderSubtype : UiBinderReferenceManager.this.subtypeToOwnerIndex.getAllUiBinderTypes()) {
                        ICompilationUnit uiBinderSubtypeCu = uiBinderSubtype.getCompilationUnit();
                        if (uiBinderSubtypeCu == null || !uiBinderSubtypeCu.equals(cu) || uiBinderSubtype.exists() && delta.getKind() != 2) continue;
                        UiBinderReferenceManager.this.subtypeToOwnerIndex.removeUiBinderType(uiBinderSubtype);
                        UiBinderReferenceManager.this.subtypeToUiXmlIndex.removeUiBinderSubtype(uiBinderSubtype);
                        UiBinderReferenceManager.this.referenceManager.removeReferences((Collection)UiBinderReferenceManager.this.referenceManager.getReferencesWithMatchingJavaElement((IJavaElement)uiBinderSubtype, EnumSet.of(ReferenceLocationType.SOURCE)));
                    }
                    return false;
                }
                if (element instanceof IJavaProject && delta.getKind() == 2) {
                    IProject project = ((IJavaProject)element).getProject();
                    UiBinderReferenceManager.this.subtypeToOwnerIndex.clear(project);
                    UiBinderReferenceManager.this.subtypeToUiXmlIndex.clear(project);
                    UiBinderReferenceManager.this.uiXmlReferencedFieldIndex.clear((IJavaProject)element);
                    UiBinderReferenceManager.this.referenceManager.removeSourceReferences(project);
                    return true;
                }
                return true;
            }
        };

        public void elementChanged(ElementChangedEvent event) {
            JavaModelSearch.visitJavaElementDelta((IJavaElementDelta)event.getDelta(), (JavaModelSearch.IJavaElementDeltaVisitor)this.visitor);
        }
    };
    private final IResourceChangeListener resourcePurger = new IResourceChangeListener(){
        private final IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (delta.getKind() != 2) {
                    return true;
                }
                IResource resource = delta.getResource();
                UiBinderReferenceManager.this.referenceManager.removeReferences((Collection)UiBinderReferenceManager.this.referenceManager.getReferencesWithMatchingResource(resource, EnumSet.of(ReferenceLocationType.SOURCE)));
                UiBinderReferenceManager.this.uiXmlReferencedFieldIndex.remove(resource.getFullPath());
                return false;
            }
        };

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getDelta() != null) {
                try {
                    event.getDelta().accept(this.visitor);
                }
                catch (CoreException e) {
                    GWTPluginLog.logError(e);
                }
            }
        }
    };
    private UiXmlReferencedFieldIndex uiXmlReferencedFieldIndex;

    private static IMemento getChild(IMemento parentMemento, String childMementoType) throws PersistenceException {
        IMemento childMemento = parentMemento.getChild(childMementoType);
        if (childMemento == null) {
            throw new PersistenceException("There is no child memento with type " + childMementoType);
        }
        return childMemento;
    }

    private static File getPersistenceFile() {
        return GWTPlugin.getDefault().getStateLocation().append(KEY_ROOT).toFile();
    }

    private UiBinderReferenceManager() {
        this.referenceManager = new ReferenceManager();
        this.subtypeToOwnerIndex = new UiBinderSubtypeToOwnerIndex();
        this.subtypeToUiXmlIndex = new UiBinderSubtypeToUiXmlIndex();
        this.uiXmlReferencedFieldIndex = new UiXmlReferencedFieldIndex();
        this.referenceRefresher = new ReferenceRefresher(this.referenceManager);
    }

    public ReferenceManager getReferenceManager() {
        return this.referenceManager;
    }

    public UiBinderSubtypeToOwnerIndex getSubtypeToOwnerIndex() {
        return this.subtypeToOwnerIndex;
    }

    public UiBinderSubtypeToUiXmlIndex getSubtypeToUiXmlIndex() {
        return this.subtypeToUiXmlIndex;
    }

    public UiXmlReferencedFieldIndex getUiXmlReferencedFieldIndex() {
        return this.uiXmlReferencedFieldIndex;
    }

    public void persist() {
        block6: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)KEY_ROOT);
            this.persist((IMemento)memento);
            File file = UiBinderReferenceManager.getPersistenceFile();
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(file);
                    memento.save((Writer)writer);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IOException e) {
                GWTPluginLog.logError(e, "Error persisting UiBinder references");
                if (!file.exists()) break block6;
                file.delete();
            }
        }
    }

    public void start() {
        this.load();
        this.referenceManager.addReferencedResourceChangeListener(this.referenceChangeListener);
        this.referenceManager.start();
        JavaCore.addElementChangedListener((IElementChangedListener)this.uiBinderSubtypePurger, (int)1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourcePurger, 1);
    }

    public void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourcePurger);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.uiBinderSubtypePurger);
        this.referenceManager.stop();
        this.referenceManager.removeReferencedResourceChangeListener(this.referenceChangeListener);
        this.persist();
    }

    private void load() {
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(UiBinderReferenceManager.getPersistenceFile());
                this.load((IMemento)XMLMemento.createReadRoot((Reader)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Throwable e) {
            GWTPluginLog.logError(e, "Could not load UiBinder indices.");
            new WorkspaceJob("Notifying of failure to load UiBinder index"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    String errorMessage = "Failed to load the UiBinder index, please clean the project to rebuild it";
                    try {
                        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            if (GWTNature.isGWTProject(project) && MarkerUtilities.findMarker((String)"com.gwtplugins.gwt.eclipse.core.javaProblemMarker", (int)-1, (int)-1, (IResource)project, (String)errorMessage, (boolean)false) == null) {
                                MarkerUtilities.createMarker((String)"com.gwtplugins.gwt.eclipse.core.javaProblemMarker", (IResource)project, (String)errorMessage, (int)2);
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException e1) {
                        GWTPluginLog.logError(e1, errorMessage);
                    }
                    return StatusUtilities.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void load(IMemento memento) throws PersistenceException {
        IMemento refManagerMemento = UiBinderReferenceManager.getChild(memento, KEY_REFERENCE_MANAGER);
        this.referenceManager = ReferenceManager.load((IMemento)refManagerMemento);
        this.referenceRefresher = new ReferenceRefresher(this.referenceManager);
        IMemento subtypeToOwnerMemento = UiBinderReferenceManager.getChild(memento, KEY_UIBINDER_SUBTYPE_OWNER);
        this.subtypeToOwnerIndex = UiBinderSubtypeToOwnerIndex.load(subtypeToOwnerMemento);
        IMemento subtypeToUiXmlMemento = UiBinderReferenceManager.getChild(memento, KEY_UIBINDER_SUBTYPE_UI_XML);
        this.subtypeToUiXmlIndex = UiBinderSubtypeToUiXmlIndex.load(subtypeToUiXmlMemento);
        IMemento uiXmlReferencedFieldsMemento = UiBinderReferenceManager.getChild(memento, KEY_UI_XML_REF_FIELDS);
        this.uiXmlReferencedFieldIndex = UiXmlReferencedFieldIndex.load(uiXmlReferencedFieldsMemento);
    }

    private void persist(IMemento memento) {
        this.referenceManager.persist(memento.createChild(KEY_REFERENCE_MANAGER));
        this.subtypeToOwnerIndex.persist(memento.createChild(KEY_UIBINDER_SUBTYPE_OWNER));
        this.subtypeToUiXmlIndex.persist(memento.createChild(KEY_UIBINDER_SUBTYPE_UI_XML));
        this.uiXmlReferencedFieldIndex.persist(memento.createChild(KEY_UI_XML_REF_FIELDS));
    }
}

