/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.model.reference;

import com.google.gdt.eclipse.core.JavaUtilities;
import com.google.gdt.eclipse.core.SseUtilities;
import com.google.gdt.eclipse.core.XmlUtilities;
import com.google.gdt.eclipse.core.java.ClasspathResourceUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gdt.eclipse.core.reference.IReference;
import com.google.gdt.eclipse.core.reference.Reference;
import com.google.gdt.eclipse.core.reference.ReferenceManager;
import com.google.gdt.eclipse.core.reference.location.ClasspathRelativeFileReferenceLocation;
import com.google.gdt.eclipse.core.reference.location.IReferenceLocation;
import com.google.gdt.eclipse.core.reference.location.LogicalJavaElementReferenceLocation;
import com.google.gdt.eclipse.core.reference.location.ReferenceLocationType;
import com.google.gdt.eclipse.core.reference.logicaljavamodel.ILogicalJavaElement;
import com.google.gdt.eclipse.core.reference.logicaljavamodel.LogicalPackage;
import com.google.gdt.eclipse.core.reference.logicaljavamodel.UiBinderImportReferenceType;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleUtilities;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.UiBinderUtilities;
import com.google.gwt.eclipse.core.uibinder.UiBinderXmlModelUtilities;
import com.google.gwt.eclipse.core.uibinder.contentassist.ElExpressionFirstFragmentComputer;
import com.google.gwt.eclipse.core.uibinder.contentassist.computers.CssSelectorNameCollector;
import com.google.gwt.eclipse.core.uibinder.problems.IValidationResultPlacementStrategy;
import com.google.gwt.eclipse.core.uibinder.problems.UiBinderProblemMarkerManager;
import com.google.gwt.eclipse.core.uibinder.sse.css.CssExtractor;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class UiBinderXmlParser {
    private static final Set<String> IGNORED_CAPITALIZED_SYNTHETIC_ELEMENTS = new HashSet<String>(Arrays.asList("com.google.gwt.user.client.ui.Dock", "com.google.gwt.user.client.ui.Cell", "com.google.gwt.user.client.ui.Tab", "com.google.gwt.user.client.ui.TabHTML", "com.google.gwt.user.client.ui.MenuItemHTML"));
    private final IPath classpathRelativeDir;
    private ElExpressionFirstFragmentComputer firstFragmentComputer;
    private final IJavaProject javaProject;
    private final Set<String> javaTypeReferences = new HashSet<String>();
    private final XmlUtilities.NodeVisitor parseNodesVisitor = new XmlUtilities.NodeVisitor(){

        public boolean visitNode(Node node) {
            UiBinderXmlParser.this.parse((IDOMNode)node);
            return true;
        }
    };
    private final UiBinderProblemMarkerManager problemMarkerManager;
    private final ReferenceManager referenceManager;
    private final IFile xmlFile;
    private final IDOMModel xmlModel;
    private final ClasspathRelativeFileReferenceLocation xmlReferenceLocation;

    public static UiBinderXmlParser newInstance(IDOMModel xmlModel, ReferenceManager referenceManager, IValidationResultPlacementStrategy<?> validationResultPlacementStrategy) throws FileNotFoundException, UiBinderException {
        IPath xmlClasspathRelativePath;
        IFile xmlFile = SseUtilities.resolveFile((IStructuredModel)xmlModel);
        if (xmlFile == null) {
            throw new FileNotFoundException("Could not find the file backing the XML model.");
        }
        IJavaProject javaProject = JavaCore.create((IProject)xmlFile.getProject());
        if (!javaProject.exists()) {
            throw new UiBinderException("The UiBinder XML file is not part of a Java project.");
        }
        try {
            xmlClasspathRelativePath = ClasspathResourceUtilities.getClasspathRelativePathOfResource((IResource)xmlFile, (IJavaProject)javaProject);
            if (xmlClasspathRelativePath == null) {
                throw new UiBinderException("Could not resolve classpath-relative path to UiBinder XML template file.");
            }
        }
        catch (JavaModelException e) {
            throw new UiBinderException(e);
        }
        return new UiBinderXmlParser(xmlModel, xmlFile, xmlClasspathRelativePath, referenceManager, validationResultPlacementStrategy, javaProject);
    }

    private UiBinderXmlParser(IDOMModel xmlModel, IFile xmlFile, IPath xmlClasspathRelativePath, ReferenceManager referenceManager, IValidationResultPlacementStrategy<?> validationResultPlacementStrategy, IJavaProject javaProject) {
        this.referenceManager = referenceManager;
        this.xmlModel = xmlModel;
        this.xmlFile = xmlFile;
        this.javaProject = javaProject;
        this.xmlReferenceLocation = new ClasspathRelativeFileReferenceLocation(xmlClasspathRelativePath);
        this.classpathRelativeDir = xmlClasspathRelativePath.removeLastSegments(1);
        this.problemMarkerManager = new UiBinderProblemMarkerManager((IResource)xmlFile, (IDocument)xmlModel.getStructuredDocument(), validationResultPlacementStrategy);
    }

    public ParseResults parse() {
        if (this.referenceManager != null) {
            this.referenceManager.removeReferences((Collection)this.referenceManager.getReferencesWithMatchingResource((IResource)this.xmlFile, EnumSet.of(ReferenceLocationType.SOURCE)));
        }
        this.problemMarkerManager.clear();
        this.firstFragmentComputer = ElExpressionFirstFragmentComputer.compute((Document)this.xmlModel.getDocument(), this.xmlFile, this.javaProject, this.problemMarkerManager);
        this.addReference((IReferenceLocation)this.xmlReferenceLocation, (IReferenceLocation)this.xmlReferenceLocation);
        XmlUtilities.visitNodes((Node)this.xmlModel.getDocument().getDocumentElement(), (XmlUtilities.NodeVisitor)this.parseNodesVisitor);
        this.markDuplicateFieldErrors();
        return new ParseResults(this.getFieldNames(), this.javaTypeReferences);
    }

    private void addReference(IReferenceLocation sourceLocation, IReferenceLocation targetLocation) {
        if (this.referenceManager != null) {
            this.referenceManager.addReference((IReference)new Reference(sourceLocation, targetLocation, this.javaProject.getProject()));
        }
    }

    private IFile getExistingFile(IPath classpathRelativePath) {
        try {
            IFile resFile = (IFile)ClasspathResourceUtilities.resolveFile((IPath)classpathRelativePath, (IJavaProject)this.javaProject);
            return resFile != null && resFile.exists() ? resFile : null;
        }
        catch (JavaModelException e) {
            GWTPluginLog.logWarning(e, "Could not resolve file at " + classpathRelativePath);
            return null;
        }
    }

    private Set<String> getFieldNames() {
        HashSet<String> fieldNames = new HashSet<String>();
        for (ElExpressionFirstFragmentComputer.ElExpressionFirstFragment fragment : this.firstFragmentComputer.getFirstFragments()) {
            fieldNames.add(fragment.getValue());
        }
        return fieldNames;
    }

    private void markDuplicateFieldErrors() {
        for (ElExpressionFirstFragmentComputer.ElExpressionFirstFragment fragment : this.firstFragmentComputer.getDuplicateFirstFragments()) {
            IRegion region;
            IDOMAttr fieldAttribute = (IDOMAttr)UiBinderXmlModelUtilities.getFieldAttribute(fragment.getNode());
            if (fieldAttribute != null) {
                region = XmlUtilities.getAttributeValueRegion((IDOMAttr)fieldAttribute);
            } else {
                List tagRegions = XmlUtilities.getElementTagRegions((IDOMElement)((IDOMElement)fragment.getNode()), (boolean)true);
                IRegion iRegion = region = tagRegions.size() > 0 ? (IRegion)tagRegions.get(0) : null;
            }
            if (region == null) continue;
            this.problemMarkerManager.setDuplicateFieldError(region, fragment.getValue());
        }
    }

    private void parse(IDOMNode node) {
        switch (node.getNodeType()) {
            case 1: {
                this.parseElement((IDOMElement)node);
                break;
            }
            case 2: {
                this.parseAttribute((IDOMAttr)node);
            }
        }
    }

    private void parseAttribute(IDOMAttr attr) {
        this.tryParseElExpression(attr);
        this.tryParseUrnImport(attr);
    }

    private void parseElement(IDOMElement element) {
        this.tryValidatePrefix(element);
        this.tryParseWidgetFromElement(element);
        this.tryParseWithElement(element);
        this.tryParseStyleElement(element);
        this.tryParseResourceElement(element);
        this.tryParseUiImportElement(element);
    }

    private void setFieldReferenceFirstFragmentUndefinedError(IRegion attrValueRegion, IRegion exprContentRegion, String exprContents) {
        String firstFragment = UiBinderUtilities.getFirstFragment(exprContents);
        int start = attrValueRegion.getOffset() + exprContentRegion.getOffset();
        this.problemMarkerManager.setFirstFragmentUndefinedError((IRegion)new Region(start, firstFragment.length()), firstFragment);
    }

    private void tryParseCssElExpression(IDOMElement styleElement, String remainingFragments, int remainingFragmentsOffsetInDoc, IRegion fieldRefRegion) {
        CssExtractor extractor = UiBinderXmlModelUtilities.createCssExtractorForStyleElement(styleElement, this.javaProject);
        if (extractor != null) {
            for (String selector : CssSelectorNameCollector.getValidSelectorNames((ICSSNode)extractor.getCssDocument())) {
                if (!selector.equals(remainingFragments)) continue;
                return;
            }
        }
        if (remainingFragments.length() > 0) {
            this.problemMarkerManager.setCssSelectorFragmentUndefinedError((IRegion)new Region(remainingFragmentsOffsetInDoc, remainingFragments.length()), remainingFragments);
        } else {
            this.problemMarkerManager.setCssSelectorFragmentUnspecifiedError(fieldRefRegion);
        }
    }

    private void tryParseElExpression(IDOMAttr attr) {
        IRegion attrValueRegion = XmlUtilities.getAttributeValueRegion((IDOMAttr)attr);
        String attrValue = attr.getNodeValue();
        if (attrValueRegion == null || attrValue == null) {
            return;
        }
        List<IRegion> exprContentRegions = UiBinderUtilities.getElExpressionRegions(attrValue);
        for (IRegion exprContentRegion : exprContentRegions) {
            String exprContents = attrValue.substring(exprContentRegion.getOffset(), exprContentRegion.getOffset() + exprContentRegion.getLength());
            ElExpressionFirstFragmentComputer.ElExpressionFirstFragment firstFragment = UiBinderUtilities.findMatchingElExpressionFirstFragment(exprContents, this.firstFragmentComputer.getFirstFragments());
            if (firstFragment == null) {
                this.setFieldReferenceFirstFragmentUndefinedError(attrValueRegion, exprContentRegion, exprContents);
                continue;
            }
            String allButFirstFragment = UiBinderUtilities.getAllButFirstFragment(exprContents);
            int allButFirstFragmentOffsetInDoc = attrValueRegion.getOffset() + exprContentRegion.getOffset() + (exprContents.length() - allButFirstFragment.length());
            IType fieldType = UiBinderXmlModelUtilities.resolveElementToJavaType((IDOMElement)firstFragment.getNode(), this.javaProject);
            if (UiBinderXmlModelUtilities.isStyleElement(firstFragment.getNode())) {
                Region fieldRefRegion = new Region(exprContentRegion.getOffset() + attrValueRegion.getOffset(), exprContentRegion.getLength());
                this.tryParseCssElExpression((IDOMElement)firstFragment.getNode(), allButFirstFragment, allButFirstFragmentOffsetInDoc, (IRegion)fieldRefRegion);
                continue;
            }
            if (fieldType == null) continue;
            this.tryParseJavaElExpression(fieldType, allButFirstFragment, allButFirstFragmentOffsetInDoc);
        }
    }

    private void tryParseJavaElExpression(IType elementType, String allButFirstFragment, final int allButFirstFragmentOffsetInDoc) {
        if ("".equals(allButFirstFragment)) {
            return;
        }
        UiBinderUtilities.resolveJavaElExpression(elementType, allButFirstFragment, new UiBinderUtilities.ElExpressionFragmentVisitor(){

            @Override
            public void visitNonterminalPrimitiveFragment(String fragment, int offset, int length) {
                UiBinderXmlParser.this.problemMarkerManager.setPrimitiveFragmentWithLeftoverFragmentsError((IRegion)new Region(allButFirstFragmentOffsetInDoc + offset, length), fragment);
            }

            @Override
            public void visitResolvedFragmentMethod(IMethod method, int offset, int length) {
                UiBinderXmlParser.this.javaTypeReferences.add(method.getDeclaringType().getFullyQualifiedName());
            }

            @Override
            public void visitUnresolvedFragment(String fragment, int offset, int length, IType enclosingType) {
                UiBinderXmlParser.this.problemMarkerManager.setMethodFragmentUndefinedError((IRegion)new Region(allButFirstFragmentOffsetInDoc + offset, length), fragment);
                UiBinderXmlParser.this.javaTypeReferences.add(enclosingType.getFullyQualifiedName());
            }
        });
    }

    private void tryParseResourceElement(IDOMElement element) {
        if (!UiBinderXmlModelUtilities.isImageElement((Node)element) && !UiBinderXmlModelUtilities.isDataElement((Node)element)) {
            return;
        }
        IDOMAttr srcAttribute = (IDOMAttr)UiBinderXmlModelUtilities.getSrcAttribute((Node)element);
        if (srcAttribute == null) {
            return;
        }
        IRegion srcAttributeRegion = XmlUtilities.getAttributeValueRegion((IDOMAttr)srcAttribute);
        if (srcAttributeRegion == null) {
            return;
        }
        IPath classpathRelativePath = this.classpathRelativeDir.append(srcAttribute.getNodeValue());
        IFile file = this.getExistingFile(classpathRelativePath);
        if (classpathRelativePath != null) {
            this.addReference((IReferenceLocation)this.xmlReferenceLocation, (IReferenceLocation)new ClasspathRelativeFileReferenceLocation(classpathRelativePath));
        }
        if (file == null || classpathRelativePath == null) {
            this.problemMarkerManager.setResourceNotFoundError(srcAttributeRegion, srcAttribute.getNodeValue());
        }
    }

    private void tryParseStyleElement(IDOMElement element) {
        String errorMessage;
        if (!UiBinderXmlModelUtilities.isStyleElement((Node)element)) {
            return;
        }
        CssExtractor extractor = UiBinderXmlModelUtilities.createCssExtractorForStyleElement(element, this.javaProject);
        if (extractor != null && (errorMessage = CssSelectorNameCollector.getDuplicateSelectorNamesErrorMessage((ICSSNode)extractor.getCssDocument())) != null) {
            List elementTagRegions = XmlUtilities.getElementTagRegions((IDOMElement)element, (boolean)true);
            this.problemMarkerManager.setDuplicateCssSelectorError((IRegion)elementTagRegions.get(0), errorMessage);
        }
        this.tryParseStyleElementSrcAttribute(element);
        this.tryParseTypeAttribute(element);
    }

    private void tryParseStyleElementSrcAttribute(IDOMElement styleElement) {
        IDOMAttr attribute = (IDOMAttr)UiBinderXmlModelUtilities.getSrcAttribute((Node)styleElement);
        if (attribute == null) {
            return;
        }
        IRegion attributeValueRegion = XmlUtilities.getAttributeValueRegion((IDOMAttr)attribute);
        if (attributeValueRegion == null) {
            return;
        }
        for (String cssPathString : UiBinderUtilities.getPathsFromDelimitedString(attribute.getNodeValue())) {
            IPath cssClasspathRelativePath = this.classpathRelativeDir.append(cssPathString);
            IFile cssFile = this.getExistingFile(cssClasspathRelativePath);
            if (cssClasspathRelativePath != null) {
                this.addReference((IReferenceLocation)this.xmlReferenceLocation, (IReferenceLocation)new ClasspathRelativeFileReferenceLocation(cssClasspathRelativePath));
            }
            if (cssFile != null && cssFile.exists() && cssClasspathRelativePath != null) continue;
            this.problemMarkerManager.setCssFileNotFoundError(attributeValueRegion, cssPathString);
        }
    }

    private void tryParseTypeAttribute(IDOMElement element) {
        IType cssResourceType;
        IDOMAttr typeAttr = (IDOMAttr)UiBinderXmlModelUtilities.getTypeAttribute((Node)element);
        if (typeAttr == null) {
            return;
        }
        IRegion valueRegion = XmlUtilities.getAttributeValueRegion((IDOMAttr)typeAttr);
        if (valueRegion == null) {
            return;
        }
        String fqType = typeAttr.getNodeValue();
        if (fqType == null) {
            return;
        }
        IType type = JavaModelSearch.findType((IJavaProject)this.javaProject, (String)fqType);
        if (!JavaModelSearch.isValidElement((IJavaElement)type)) {
            this.problemMarkerManager.setTypeUndefinedError(valueRegion, fqType);
        } else if (UiBinderXmlModelUtilities.isStyleElement((Node)element) && (cssResourceType = ClientBundleUtilities.findCssResourceType(this.javaProject)) != null) {
            try {
                if (!JavaUtilities.isSubtype((IType)cssResourceType, (IType)type)) {
                    this.problemMarkerManager.setNotCssResourceSubtypeError(valueRegion, fqType);
                }
            }
            catch (JavaModelException e) {
                GWTPluginLog.logWarning(e, "Could not validate the <ui:style>'s type attribute.");
            }
        }
        this.javaTypeReferences.add(fqType);
    }

    private void tryParseUiImportElement(IDOMElement element) {
        if (!UiBinderXmlModelUtilities.isImportElement((Node)element)) {
            return;
        }
        IType enclosingType = UiBinderXmlModelUtilities.resolveElementToJavaType(element, this.javaProject);
        if (enclosingType != null) {
            this.addReference((IReferenceLocation)this.xmlReferenceLocation, (IReferenceLocation)new LogicalJavaElementReferenceLocation((ILogicalJavaElement)new UiBinderImportReferenceType(enclosingType)));
        }
    }

    private void tryParseUrnImport(IDOMAttr attr) {
        IPackageFragmentRoot[] packageFragmentRoots;
        if (!(UiBinderXmlModelUtilities.isUiBinderElement(attr.getOwnerElement()) && "http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) && attr.getNodeValue() != null && attr.getNodeValue().startsWith("urn:import:"))) {
            return;
        }
        int urnImportLength = "urn:import:".length();
        String packageName = attr.getNodeValue().substring(urnImportLength);
        this.addReference((IReferenceLocation)this.xmlReferenceLocation, (IReferenceLocation)new LogicalJavaElementReferenceLocation((ILogicalJavaElement)new LogicalPackage(packageName)));
        try {
            packageFragmentRoots = this.javaProject.getAllPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e, "Could not parse UiBinder urn:import attribute");
            return;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots;
        int n = packageFragmentRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
            IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
            if (JavaModelSearch.isValidElement((IJavaElement)packageFragment)) {
                return;
            }
            IType type = JavaModelSearch.findType((IJavaProject)this.javaProject, (String)packageFragment.getElementName());
            if (type != null) {
                return;
            }
            ++n2;
        }
        IRegion attrValueRegion = XmlUtilities.getAttributeValueRegion((IDOMAttr)attr);
        if (attrValueRegion == null) {
            return;
        }
        int offset = attrValueRegion.getOffset() + urnImportLength;
        int length = attrValueRegion.getLength() - urnImportLength;
        this.problemMarkerManager.setPackageUndefinedError((IRegion)new Region(offset, length), packageName);
    }

    private void tryParseWidgetFromElement(IDOMElement element) {
        String fqWidgetType = UiBinderXmlModelUtilities.computeQualifiedWidgetTypeName((Node)element);
        if (fqWidgetType == null) {
            return;
        }
        if (IGNORED_CAPITALIZED_SYNTHETIC_ELEMENTS.contains(fqWidgetType)) {
            return;
        }
        this.javaTypeReferences.add(fqWidgetType);
        IType type = JavaModelSearch.findType((IJavaProject)this.javaProject, (String)fqWidgetType);
        boolean validType = JavaModelSearch.isValidElement((IJavaElement)type);
        List tagRegions = XmlUtilities.getElementTagRegions((IDOMElement)element, (boolean)false);
        for (IRegion region : tagRegions) {
            if (validType) continue;
            this.problemMarkerManager.setWidgetUndefinedError(region, fqWidgetType);
        }
    }

    private void tryParseWithElement(IDOMElement element) {
        if (!UiBinderXmlModelUtilities.isWithElement((Node)element)) {
            return;
        }
        this.tryParseTypeAttribute(element);
    }

    private void tryValidatePrefix(IDOMElement element) {
        String prefix = element.getPrefix();
        if (prefix != null && element.getNamespaceURI() == null) {
            for (IRegion region : XmlUtilities.getElementTagRegions((IDOMElement)element, (boolean)true)) {
                this.problemMarkerManager.setNamespacePrefixUndefinedError(region, prefix);
            }
        }
    }

    public static class ParseResults {
        private final Set<String> fieldNames;
        private final Set<String> javaTypeReferences;

        public ParseResults(Set<String> fieldNames, Set<String> javaTypeReferences) {
            this.fieldNames = fieldNames;
            this.javaTypeReferences = javaTypeReferences;
        }

        public Set<String> getFieldNames() {
            return this.fieldNames;
        }

        public Set<String> getJavaTypeReferences() {
            return this.javaTypeReferences;
        }
    }
}

