/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.problems;

import com.google.gdt.eclipse.core.MarkerUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.problems.IValidationResultPlacementStrategy;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class MarkerPlacementStrategy
implements IValidationResultPlacementStrategy<IMarker> {
    private final String markerId;

    public MarkerPlacementStrategy(String markerId) {
        this.markerId = markerId;
    }

    @Override
    public void clearValidationResults(IResource resource) {
        try {
            resource.deleteMarkers(this.markerId, true, 2);
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e, "Could not clear problem markers.");
        }
    }

    @Override
    public IMarker placeValidationResult(IResource resource, IDocument document, IRegion position, String message, int severity) {
        try {
            return this.createMarker(resource, document, position, message, severity);
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e, "Could not create marker: {0} (on {1})", message, resource.getLocation());
            return null;
        }
    }

    private IMarker createMarker(IResource resource, IDocument document, IRegion position, String msg, int severity) throws CoreException {
        if (this.isDuplicate(resource, position, msg)) {
            return null;
        }
        IMarker marker = MarkerUtilities.createMarker((String)this.markerId, (IResource)resource, (String)msg, (int)severity);
        marker.setAttribute("charStart", position.getOffset());
        marker.setAttribute("charEnd", position.getOffset() + position.getLength());
        try {
            marker.setAttribute("lineNumber", document.getLineOfOffset(position.getOffset()) + 1);
        }
        catch (BadLocationException e) {
            GWTPluginLog.logWarning(e, "Unexpected bad location when getting line number for marker.");
        }
        return marker;
    }

    private boolean isDuplicate(IResource resource, IRegion position, String msg) throws CoreException {
        int end;
        int start = position.getOffset();
        return MarkerUtilities.findMarker((String)this.markerId, (int)start, (int)(end = position.getOffset() + position.getLength()), (IResource)resource, (String)msg, (boolean)true) != null;
    }
}

