/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.problems;

import com.google.gwt.eclipse.core.uibinder.problems.IValidationResultPlacementStrategy;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ReporterMessagePlacementStrategy
implements IValidationResultPlacementStrategy<IMessage> {
    private final IValidator validator;
    private final IReporter reporter;
    private boolean isClearAllowed = true;

    private static int severityFromIMarkerSeverity(int imarkerSeverity) {
        switch (imarkerSeverity) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 4;
            }
        }
        return 4;
    }

    public ReporterMessagePlacementStrategy(IValidator validator, IReporter reporter) {
        this.validator = validator;
        this.reporter = reporter;
    }

    @Override
    public void clearValidationResults(IResource resource) {
        if (this.isClearAllowed) {
            this.reporter.removeAllMessages(this.validator);
        }
    }

    public boolean isClearAllowed() {
        return this.isClearAllowed;
    }

    @Override
    public IMessage placeValidationResult(IResource resource, IDocument document, IRegion position, String message, int severity) {
        LocalizedMessage validationMessage = new LocalizedMessage(ReporterMessagePlacementStrategy.severityFromIMarkerSeverity(severity), message);
        validationMessage.setLength(position.getLength());
        validationMessage.setOffset(position.getOffset());
        this.reporter.addMessage(this.validator, (IMessage)validationMessage);
        return validationMessage;
    }

    public void setClearAllowed(boolean isClearAllowed) {
        this.isClearAllowed = isClearAllowed;
    }
}

