/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.problems;

import com.google.gdt.eclipse.core.markers.GdtProblemSeverities;
import com.google.gdt.eclipse.core.markers.GdtProblemSeverity;
import com.google.gdt.eclipse.core.markers.IGdtProblemType;
import com.google.gwt.eclipse.core.uibinder.problems.IValidationResultPlacementStrategy;
import com.google.gwt.eclipse.core.uibinder.problems.UiBinderTemplateProblemType;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class UiBinderProblemMarkerManager {
    public static final String MARKER_ID = "com.gwtplugins.gwt.eclipse.core.uiBinderProblemMarker";
    private final IDocument document;
    private final IResource resource;
    private final IValidationResultPlacementStrategy<?> strategy;

    public UiBinderProblemMarkerManager(IResource resource, IDocument document, IValidationResultPlacementStrategy<?> strategy) {
        this.resource = resource;
        this.document = document;
        this.strategy = strategy;
    }

    public void clear() {
        this.strategy.clearValidationResults(this.resource);
    }

    public void setCssFileNotFoundError(IRegion position, String cssFileName) {
        this.placeValidationResult(UiBinderTemplateProblemType.CSS_FILE_NOT_FOUND, position, cssFileName);
    }

    public void setCssSelectorFragmentUndefinedError(IRegion position, String fieldValue) {
        this.placeValidationResult(UiBinderTemplateProblemType.CSS_SELECTOR_FRAGMENT_UNDEFINED, position, fieldValue);
    }

    public void setCssSelectorFragmentUnspecifiedError(IRegion fieldRefRegion) {
        this.placeValidationResult(UiBinderTemplateProblemType.CSS_SELECTOR_FRAGMENT_UNSPECIFIED, fieldRefRegion, new String[0]);
    }

    public void setDuplicateCssSelectorError(IRegion position, String errorMessage) {
        this.placeValidationResult(UiBinderTemplateProblemType.DUPLICATE_CSS_SELECTOR, position, errorMessage);
    }

    public void setDuplicateFieldError(IRegion position, String fragment) {
        this.placeValidationResult(UiBinderTemplateProblemType.DUPLICATE_FIELD, position, fragment);
    }

    public void setFieldNotStaticError(IRegion position, String fieldValue) {
        this.placeValidationResult(UiBinderTemplateProblemType.FIELD_NOT_STATIC, position, fieldValue);
    }

    public void setFieldNotVisibleError(IRegion position, String fieldValue) {
        this.placeValidationResult(UiBinderTemplateProblemType.FIELD_NOT_VISIBLE, position, fieldValue);
    }

    public void setFieldUndefinedError(IRegion position, String fieldValue) {
        this.placeValidationResult(UiBinderTemplateProblemType.FIELD_UNDEFINED, position, fieldValue);
    }

    public void setFirstFragmentUndefinedError(IRegion position, String fieldValue) {
        this.placeValidationResult(UiBinderTemplateProblemType.FIRST_FRAGMENT_UNDEFINED, position, fieldValue);
    }

    public void setImportMissingFieldAttr(IRegion position, String widget) {
        this.placeValidationResult(UiBinderTemplateProblemType.IMPORT_MISSING_FIELD_ATTR, position, widget);
    }

    public void setMethodFragmentUndefinedError(IRegion position, String fieldValue) {
        this.placeValidationResult(UiBinderTemplateProblemType.METHOD_FRAGMENT_UNDEFINED, position, fieldValue);
    }

    public void setNamespacePrefixUndefinedError(IRegion position, String prefix) {
        this.placeValidationResult(UiBinderTemplateProblemType.NAMESPACE_PREFIX_UNDEFINED, position, prefix);
    }

    public void setNotCssResourceSubtypeError(IRegion position, String fqType) {
        this.placeValidationResult(UiBinderTemplateProblemType.NOT_CSS_RESOURCE_SUBTYPE, position, fqType);
    }

    public void setPackageUndefinedError(IRegion position, String packageName) {
        this.placeValidationResult(UiBinderTemplateProblemType.PACKAGE_UNDEFINED, position, packageName);
    }

    public void setPrimitiveFragmentWithLeftoverFragmentsError(IRegion position, String primitiveFragment) {
        this.placeValidationResult(UiBinderTemplateProblemType.PRIMITIVE_FRAGMENT_WITH_LEFTOVER_FRAGMENTS, position, primitiveFragment);
    }

    public void setResourceNotFoundError(IRegion position, String imagePath) {
        this.placeValidationResult(UiBinderTemplateProblemType.RESOURCE_NOT_FOUND, position, imagePath);
    }

    public void setTypeNotVisibleError(IRegion position, String fieldValue) {
        this.placeValidationResult(UiBinderTemplateProblemType.TYPE_NOT_ACCESSIBLE, position, fieldValue);
    }

    public void setTypeUndefinedError(IRegion position, String type) {
        this.placeValidationResult(UiBinderTemplateProblemType.TYPE_UNDEFINED, position, type);
    }

    public void setWidgetUndefinedError(IRegion position, String widget) {
        this.placeValidationResult(UiBinderTemplateProblemType.WIDGET_UNDEFINED, position, widget);
    }

    private void placeValidationResult(UiBinderTemplateProblemType problemType, IRegion position, String ... messageArgs) {
        GdtProblemSeverity severity = GdtProblemSeverities.getInstance().getSeverity((IGdtProblemType)problemType);
        if (severity != GdtProblemSeverity.IGNORE) {
            String msg = MessageFormat.format(problemType.getMessage(), messageArgs);
            this.strategy.placeValidationResult(this.resource, this.document, position, msg, severity.getMarkerSeverity());
        }
    }
}

