/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.problems;

import com.google.gdt.eclipse.core.markers.GdtProblemCategory;
import com.google.gdt.eclipse.core.markers.GdtProblemSeverity;
import com.google.gdt.eclipse.core.markers.IGdtProblemType;

public enum UiBinderTemplateProblemType implements IGdtProblemType
{
    CSS_FILE_NOT_FOUND("Missing CSS file", "CSS file {0} is missing", GdtProblemSeverity.ERROR),
    CSS_SELECTOR_FRAGMENT_UNDEFINED("Undefined CSS selector", "CSS selector {0} is undefined", GdtProblemSeverity.ERROR),
    CSS_SELECTOR_FRAGMENT_UNSPECIFIED("Incomplete CSS field reference", "Incomplete field reference, specify a CSS selector", GdtProblemSeverity.ERROR),
    DUPLICATE_CSS_SELECTOR("Duplicate CSS selector", "{0}", GdtProblemSeverity.ERROR),
    DUPLICATE_FIELD("Duplicate ui:field", "Field {0} cannot appear multiple times in one template", GdtProblemSeverity.ERROR),
    FIELD_NOT_STATIC("Field not static", "Field {0} is not static", GdtProblemSeverity.ERROR),
    FIELD_NOT_VISIBLE("Field not accessible", "Field {0} is not accessible", GdtProblemSeverity.ERROR),
    FIELD_UNDEFINED("Field undefined", "Field {0} is undefined", GdtProblemSeverity.ERROR),
    FIRST_FRAGMENT_UNDEFINED("Undefined field reference first fragment", "Field reference to {0} is undefined", GdtProblemSeverity.ERROR),
    IMPORT_MISSING_FIELD_ATTR("ui:import tag missing field attribute", "ui:import tag is missing the field attribute", GdtProblemSeverity.ERROR),
    METHOD_FRAGMENT_UNDEFINED("Undefined field reference method fragment", "Method {0} is undefined", GdtProblemSeverity.ERROR),
    NAMESPACE_PREFIX_UNDEFINED("Undefined namespace prefix", "Namespace prefix {0} is undefined", GdtProblemSeverity.ERROR),
    NOT_CSS_RESOURCE_SUBTYPE("ui:style type not a CssResource subclass", "Type {0} must be a subtype of CssResource", GdtProblemSeverity.ERROR),
    PACKAGE_UNDEFINED("Unresolved package name in import", "Package {0} cannot be resolved", GdtProblemSeverity.ERROR),
    PRIMITIVE_FRAGMENT_WITH_LEFTOVER_FRAGMENTS("Field reference with non-terminal primitive", "Method {0} returns a primitive, but there are remaining fragments in the field reference", GdtProblemSeverity.ERROR),
    RESOURCE_NOT_FOUND("Missing resource file", "Resource {0} is missing", GdtProblemSeverity.ERROR),
    TYPE_NOT_ACCESSIBLE("Type not accessible", "Type {0} is not accessible", GdtProblemSeverity.ERROR),
    TYPE_UNDEFINED("Unresolved ui:type", "Type {0} cannot be resolved", GdtProblemSeverity.ERROR),
    WIDGET_UNDEFINED("Unresolved widget", "Widget {0} cannot be resolved", GdtProblemSeverity.ERROR);

    private final GdtProblemSeverity defaultSeverity;
    private final String description;
    private final String message;

    private UiBinderTemplateProblemType(String description, String message, GdtProblemSeverity defaultSeverity) {
        this.description = description;
        this.message = message;
        this.defaultSeverity = defaultSeverity;
    }

    public GdtProblemCategory getCategory() {
        return GdtProblemCategory.UI_BINDER;
    }

    public GdtProblemSeverity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMessage() {
        return this.message;
    }

    public int getProblemId() {
        return 400 + this.ordinal() + 1;
    }

    public String toString() {
        return this.description;
    }
}

