/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.resources;

import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.formatter.UiBinderFormatter;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;

public abstract class UiBinderResourceCreator {
    private static final String GWT_TYPE_NAME = "com.google.gwt.core.client.GWT";

    protected static String createElement(String outerTagName, boolean addComments, String commentResourceName, boolean addSampleContent, String sampleContentResourceName) throws CoreException {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + outerTagName + ">\n");
        if (addComments) {
            sb.append(UiBinderResourceCreator.getResourceWithNoReplacements(commentResourceName));
            sb.append('\n');
        }
        if (addSampleContent) {
            sb.append(UiBinderResourceCreator.getResourceWithNoReplacements(sampleContentResourceName));
            sb.append('\n');
        }
        sb.append("</" + outerTagName + ">");
        return sb.toString();
    }

    protected static String createStyleElement(boolean addComments, boolean addSampleContent) throws CoreException {
        StringBuilder sb = new StringBuilder();
        sb.append("<ui:style>\n");
        if (addComments) {
            sb.append(UiBinderResourceCreator.getResourceWithNoReplacements("uixml-css-comment.template"));
            sb.append('\n');
        }
        if (addSampleContent) {
            sb.append(UiBinderResourceCreator.getResourceWithNoReplacements("uixml-css-sample-content.template"));
            sb.append('\n');
        }
        sb.append("</ui:style>");
        return sb.toString();
    }

    protected static String createUiBinderStaticField(IType ownerClass, NewTypeWizardPage.ImportsManager imports) {
        String uiBinderTypeName = String.valueOf(ownerClass.getElementName()) + "UiBinder";
        StringBuilder sb = new StringBuilder();
        sb.append("private static ");
        sb.append(uiBinderTypeName);
        sb.append(" uiBinder = ");
        sb.append(imports.addImport(GWT_TYPE_NAME));
        sb.append(".create(");
        sb.append(uiBinderTypeName);
        sb.append(".class);");
        return sb.toString();
    }

    protected static String createUiBinderSubtype(IType ownerClass, String uiRootTypeName, NewTypeWizardPage.ImportsManager imports) {
        StringBuilder sb = new StringBuilder();
        sb.append("interface ");
        sb.append(ownerClass.getElementName());
        sb.append("UiBinder");
        sb.append(" extends ");
        sb.append(imports.addImport("com.google.gwt.uibinder.client.UiBinder"));
        sb.append("<");
        sb.append(imports.addImport(uiRootTypeName));
        sb.append(", ");
        sb.append(imports.addImport(ownerClass.getFullyQualifiedName()));
        sb.append(">");
        sb.append(" {}");
        return sb.toString();
    }

    protected static String createUiField(String fieldTypeName, String fieldName, NewTypeWizardPage.ImportsManager imports) {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(imports.addImport("com.google.gwt.uibinder.client.UiField"));
        sb.append(" ");
        sb.append(imports.addImport(fieldTypeName));
        sb.append(" ");
        sb.append(fieldName);
        sb.append(";");
        return sb.toString();
    }

    private static Object getResourceWithNoReplacements(String resourceName) throws CoreException {
        return ResourceUtils.getResourceAsString(UiBinderResourceCreator.class, (String)resourceName);
    }

    public abstract void createOwnerClassMembers(IType var1, NewTypeWizardPage.ImportsManager var2, boolean var3, boolean var4, IProgressMonitor var5) throws JavaModelException;

    public IFile createUiXmlFile(IPath filePath, boolean addComments, boolean addSampleContent) throws CoreException {
        InputStream contents = this.createUiXmlSource(addComments, addSampleContent);
        IFile file = ResourceUtils.createFile((IPath)filePath, (InputStream)contents);
        try {
            UiBinderFormatter.format(file, true);
        }
        catch (UiBinderException e) {
            throw new CoreException(StatusUtilities.newErrorStatus((Exception)e, (String)"com.gwtplugins.gwt.eclipse.core"));
        }
        return file;
    }

    public abstract String getOwnerSuperclass();

    public abstract List<String> getOwnerSuperinterfaces(boolean var1);

    protected abstract String createMarkupElement(boolean var1, boolean var2) throws CoreException;

    protected abstract InputStream createUiXmlSource(boolean var1, boolean var2) throws CoreException;
}

