/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.resources;

import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gwt.eclipse.core.uibinder.resources.UiBinderResourceCreator;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;

public class WidgetBasedUiBinderResourceCreator
extends UiBinderResourceCreator {
    private static String createCtor(IType ownerClass, boolean addSampleContent, boolean addComments) {
        StringBuilder sb = new StringBuilder();
        sb.append("public ");
        sb.append(ownerClass.getElementName());
        sb.append("(");
        if (addSampleContent) {
            sb.append("String firstName");
        }
        sb.append(") {\n");
        sb.append("\tinitWidget(uiBinder.createAndBindUi(this));\n");
        if (addSampleContent) {
            if (addComments) {
                sb.append('\n');
                sb.append("\t// Can access @UiField after calling createAndBindUi\n");
            }
            sb.append("\tbutton.setText(firstName);\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String createDefaultCtor(IType ownerClass, boolean addComments) {
        StringBuilder sb = new StringBuilder();
        if (addComments) {
            sb.append("/**\n");
            sb.append(" * Because this class has a default constructor, it can\n");
            sb.append(" * be used as a binder template. In other words, it can be used in other\n");
            sb.append(" * *.ui.xml files as follows:\n");
            sb.append(" * <ui:UiBinder xmlns:ui=\"urn:ui:com.google.gwt.uibinder\"\n");
            sb.append("  *   xmlns:g=\"urn:import:**user's package**\">\n");
            sb.append(" *  <g:**UserClassName**>Hello!</g:**UserClassName>\n");
            sb.append(" * </ui:UiBinder>\n");
            sb.append(" * Note that depending on the widget that is used, it may be necessary to\n");
            sb.append(" * implement HasHTML instead of HasText.\n");
            sb.append(" */\n");
        }
        sb.append("public ");
        sb.append(ownerClass.getElementName());
        sb.append("(");
        sb.append(") {\n");
        sb.append("\tinitWidget(uiBinder.createAndBindUi(this));\n");
        sb.append("}");
        return sb.toString();
    }

    private static String createEventHandler(NewTypeWizardPage.ImportsManager imports) {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(imports.addImport("com.google.gwt.uibinder.client.UiHandler"));
        sb.append("(\"button\")\n");
        sb.append("void onClick(");
        sb.append(imports.addImport("com.google.gwt.event.dom.client.ClickEvent"));
        sb.append(" e) {\n");
        sb.append(imports.addImport("com.google.gwt.user.client.Window"));
        sb.append(".alert(\"Hello!\");\n");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void createOwnerClassMembers(IType ownerClass, NewTypeWizardPage.ImportsManager imports, boolean addComments, boolean addSampleContent, IProgressMonitor monitor) throws JavaModelException {
        String uiBinderDecl = WidgetBasedUiBinderResourceCreator.createUiBinderSubtype(ownerClass, "com.google.gwt.user.client.ui.Widget", imports);
        ownerClass.createType(uiBinderDecl, null, false, monitor);
        String uiBinderField = WidgetBasedUiBinderResourceCreator.createUiBinderStaticField(ownerClass, imports);
        ownerClass.createField(uiBinderField, null, false, monitor);
        String defaultCtorSrc = WidgetBasedUiBinderResourceCreator.createDefaultCtor(ownerClass, addComments);
        ownerClass.createMethod(defaultCtorSrc, null, false, monitor);
        if (addSampleContent) {
            String ctorSrc = WidgetBasedUiBinderResourceCreator.createCtor(ownerClass, addSampleContent, addComments);
            IMethod ctor = ownerClass.createMethod(ctorSrc, null, false, monitor);
            String uiField = WidgetBasedUiBinderResourceCreator.createUiField("com.google.gwt.user.client.ui.Button", "button", imports);
            ownerClass.createField(uiField, (IJavaElement)ctor, false, monitor);
            String eventHandler = WidgetBasedUiBinderResourceCreator.createEventHandler(imports);
            ownerClass.createMethod(eventHandler, null, false, monitor);
            String getterSrc = this.createGetter(ownerClass);
            ownerClass.createMethod(getterSrc, null, false, monitor);
            String setterSrc = this.createSetter(ownerClass, addComments);
            ownerClass.createMethod(setterSrc, null, false, monitor);
        }
    }

    @Override
    public String getOwnerSuperclass() {
        return "com.google.gwt.user.client.ui.Composite";
    }

    @Override
    public List<String> getOwnerSuperinterfaces(boolean addSampleContent) {
        if (addSampleContent) {
            return Arrays.asList("com.google.gwt.user.client.ui.HasText");
        }
        return Collections.emptyList();
    }

    @Override
    protected String createMarkupElement(boolean addComments, boolean addSampleContent) throws CoreException {
        return WidgetBasedUiBinderResourceCreator.createElement("g:HTMLPanel", addComments, "uixml-markup-comment-widgets.template", addSampleContent, "uixml-markup-sample-content-widgets.template");
    }

    @Override
    protected InputStream createUiXmlSource(boolean addComments, boolean addSampleContent) throws CoreException {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("@UiBinderXmlNs@", "urn:ui:com.google.gwt.uibinder");
        replacements.put("@GwtWidgetsLibNsPrefix@", "g");
        replacements.put("@GwtWidgetsLibNs@", "com.google.gwt.user.client.ui");
        replacements.put("@StyleElement@", WidgetBasedUiBinderResourceCreator.createStyleElement(addComments, addSampleContent));
        replacements.put("@MarkupElement@", this.createMarkupElement(addComments, addSampleContent));
        return ResourceUtils.getResourceAsStreamAndFilterContents(this.getClass(), replacements, (String)"uixml-widgets.template");
    }

    private String createGetter(IType ownerClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("public void setText(String text) {\n");
        sb.append("\tbutton.setText(text);\n");
        sb.append("}");
        return sb.toString();
    }

    private String createSetter(IType ownerClass, boolean addComments) {
        StringBuilder sb = new StringBuilder();
        if (addComments) {
            sb.append("/**\n");
            sb.append(" * Gets invoked when the default constructor is called\n");
            sb.append(" * and a string is provided in the ui.xml file.\n");
            sb.append(" */\n");
        }
        sb.append("public String getText() {\n");
        sb.append("\treturn button.getText();\n");
        sb.append("}");
        return sb.toString();
    }
}

