/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.sse;

import com.google.gdt.eclipse.core.SseUtilities;
import com.google.gwt.eclipse.core.uibinder.UiBinderXmlModelUtilities;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;

public class StructuredTextPartitionerForUiBinderXml
extends StructuredTextPartitionerForXML {
    private static final Set<String> CSS_DISALLOWED_TYPES = new HashSet<String>(Arrays.asList("XML_EMPTY_TAG_CLOSE", "XML_END_TAG_OPEN", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_VALUE", "XML_TAG_CLOSE", "XML_TAG_NAME", "XML_TAG_OPEN"));
    private static final Set<String> OPEN_TYPES = Collections.singleton("XML_TAG_OPEN");
    private static final Set<String> CLOSED_TYPES = new HashSet<String>(Arrays.asList("XML_TAG_CLOSE", "XML_EMPTY_TAG_CLOSE"));

    public String getPartitionType(ITextRegion region, int offset) {
        if (this.isCssPartition(region, offset)) {
            return "org.eclipse.wst.css.STYLE";
        }
        return super.getPartitionType(region, offset);
    }

    public IDocumentPartitioner newInstance() {
        return new StructuredTextPartitionerForUiBinderXml();
    }

    private boolean isCssPartition(ITextRegion textRegion, int offset) {
        if (CSS_DISALLOWED_TYPES.contains(textRegion.getType())) {
            return false;
        }
        IStructuredDocumentRegion region = this.fStructuredDocument.getRegionAtCharacterOffset(offset);
        IStructuredDocumentRegion tagOpenRegion = SseUtilities.findStructuredDocumentRegion(OPEN_TYPES, CLOSED_TYPES, (IStructuredDocumentRegion)region, (boolean)false);
        if (tagOpenRegion == null) {
            return false;
        }
        return this.isStyleElement(tagOpenRegion);
    }

    private boolean isStyleElement(IStructuredDocumentRegion styleElementRegion) {
        if (styleElementRegion == null) {
            return false;
        }
        String uiBinderPrefix = null;
        ITextRegionList regions = styleElementRegion.getRegions();
        int i = 0;
        while (i < regions.size()) {
            ITextRegion styleElementChildTextRegion = regions.get(i);
            if (styleElementChildTextRegion.getType().equals("XML_TAG_NAME")) {
                String tagName;
                if (uiBinderPrefix == null) {
                    uiBinderPrefix = UiBinderXmlModelUtilities.resolveUiBinderNamespacePrefix(styleElementRegion.getParentDocument());
                }
                if ((tagName = styleElementRegion.getText(styleElementChildTextRegion)).equalsIgnoreCase(String.valueOf(uiBinderPrefix) + ":" + "style")) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

