/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.sse;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.contentassist.UiBinderXmlCompletionProcessor;
import com.google.gwt.eclipse.core.uibinder.formatter.UiBinderFormatter;
import com.google.gwt.eclipse.core.uibinder.sse.css.InlinedCssContentAssistProcessor;
import com.google.gwt.eclipse.core.uibinder.sse.css.LineStyleProviderForInlinedCss;
import com.google.gwt.eclipse.core.uibinder.sse.css.StructuredAutoEditStrategyInlinedCss;
import com.google.gwt.eclipse.platform.uibinder.UiBinderStructuredRegionProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.css.ui.StructuredTextViewerConfigurationCSS;
import org.eclipse.wst.css.ui.internal.autoedit.StructuredAutoEditStrategyCSS;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;

public class UiBinderXmlSourceViewerConfiguration
extends StructuredTextViewerConfigurationXML {
    private static final String[] ADDITIONAL_CONTENT_TYPES = new String[]{"org.eclipse.wst.css.STYLE"};
    private final StructuredTextViewerConfigurationCSS cssSourceViewerConfiguration = new StructuredTextViewerConfigurationCSS();

    public UiBinderXmlSourceViewerConfiguration() {
        try {
            UiBinderStructuredRegionProcessor.setAsReconciler((StructuredTextViewerConfiguration)this);
        }
        catch (Exception e) {
            GWTPluginLog.logError(e, "Could not set custom UiBinder reconciler.");
        }
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType == "org.eclipse.wst.css.STYLE") {
            IAutoEditStrategy[] autoEditStrategies = this.cssSourceViewerConfiguration.getAutoEditStrategies(sourceViewer, contentType);
            int i = 0;
            while (i < autoEditStrategies.length) {
                if (autoEditStrategies[i] instanceof StructuredAutoEditStrategyCSS) {
                    autoEditStrategies[i] = new StructuredAutoEditStrategyInlinedCss();
                }
                ++i;
            }
            return autoEditStrategies;
        }
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        ArrayList<String> contentTypes = new ArrayList<String>(Arrays.asList(super.getConfiguredContentTypes(sourceViewer)));
        contentTypes.addAll(Arrays.asList(ADDITIONAL_CONTENT_TYPES));
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        return UiBinderFormatter.createFormatter(this.getConfiguredDocumentPartitioning(sourceViewer));
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        if (contentType == "org.eclipse.wst.css.STYLE") {
            return this.cssSourceViewerConfiguration.getIndentPrefixes(sourceViewer, contentType);
        }
        return super.getIndentPrefixes(sourceViewer, contentType);
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        if (partitionType == "org.eclipse.wst.css.STYLE") {
            return new LineStyleProvider[]{new LineStyleProviderForInlinedCss()};
        }
        return super.getLineStyleProviders(sourceViewer, partitionType);
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        if (partitionType == "org.eclipse.wst.css.STYLE") {
            return new IContentAssistProcessor[]{new InlinedCssContentAssistProcessor()};
        }
        return new IContentAssistProcessor[]{new UiBinderXmlCompletionProcessor()};
    }
}

