/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.sse.css;

import com.google.gwt.eclipse.core.uibinder.sse.css.model.CssResourceAwareModelRepairer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.css.core.internal.modelhandler.CSSModelLoader;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class CssExtractor {
    private final ICSSDocument cssDocument;
    private final IStructuredDocument structuredDocument;
    private final ICSSModel cssModel;

    public static CssExtractor extract(IDocument document, int offset, int length, CSSModelLoader cssModelLoader) {
        try {
            String cssBlock = document.get(offset, length);
            return CssExtractor.extract(cssBlock, cssModelLoader);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static CssExtractor extract(String cssBlock, CSSModelLoader cssModelLoader) {
        ICSSModel model = (ICSSModel)cssModelLoader.createModel();
        ICSSDocument cssDocument = model.getDocument();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(cssBlock);
        CssResourceAwareModelRepairer modelRepairer = new CssResourceAwareModelRepairer(structuredDocument, model);
        modelRepairer.repair();
        return new CssExtractor(cssDocument, structuredDocument, model);
    }

    private CssExtractor(ICSSDocument cssDocument, IStructuredDocument structuredDocument, ICSSModel cssModel) {
        this.cssDocument = cssDocument;
        this.structuredDocument = structuredDocument;
        this.cssModel = cssModel;
    }

    public ICSSDocument getCssDocument() {
        return this.cssDocument;
    }

    public ICSSModel getCssModel() {
        return this.cssModel;
    }

    public IStructuredDocument getStructuredDocument() {
        return this.structuredDocument;
    }
}

