/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.sse.css;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.formatter.AbstractFormattingStrategy;
import com.google.gwt.eclipse.core.uibinder.sse.css.CssExtractor;
import com.google.gwt.eclipse.core.uibinder.sse.css.model.CssResourceAwareModelLoader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceGenerator;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;

public class ExtractingCssFormattingStrategy
extends AbstractFormattingStrategy {
    protected String adjustFormattedCssWhitespace(String formattedCssBlock, IDocument originalDocument, TypedPosition partition, CssExtractor extractor) {
        return formattedCssBlock;
    }

    @Override
    protected void format(IDocument document, TypedPosition partition) {
        CssExtractor extractor = CssExtractor.extract(document, partition.getOffset(), partition.getLength(), new CssResourceAwareModelLoader());
        if (extractor == null) {
            GWTPluginLog.logError("Could not format CSS block due to error in extracting the document.");
            return;
        }
        ICSSDocument cssDocument = extractor.getCssDocument();
        String formattedCssBlock = this.formatCss(cssDocument);
        if ((formattedCssBlock = this.adjustFormattedCssWhitespace(formattedCssBlock, document, partition, extractor)) == null) {
            return;
        }
        try {
            String currentText = document.get(partition.getOffset(), partition.getLength());
            if (formattedCssBlock.equals(currentText)) {
                return;
            }
            if (!StringUtilities.equalsIgnoreWhitespace((String)formattedCssBlock, (String)currentText, (boolean)true)) {
                GWTPluginLog.logError(new Exception(), "Could not format text because the CSS formatter caused non-whitespace/non-case changes.  Please ensure your CSS is valid.");
                return;
            }
            document.replace(partition.getOffset(), partition.getLength(), formattedCssBlock.toString());
        }
        catch (BadLocationException e) {
            GWTPluginLog.logWarning(e, "Could not format CSS block.");
        }
    }

    private String formatCss(ICSSDocument cssDocument) {
        CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)cssDocument);
        String formattedCssBlock = formatter.format((ICSSNode)cssDocument).toString();
        return formattedCssBlock;
    }
}

