/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.sse.css;

import com.google.gdt.eclipse.core.SseUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.sse.css.CssExtractor;
import com.google.gwt.eclipse.core.uibinder.sse.css.CssProposalArrangerCaller;
import com.google.gwt.eclipse.core.uibinder.sse.css.model.CssResourceAwareModelLoader;
import com.google.gwt.eclipse.core.uibinder.text.IndentationFixingCompletionProposal;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class InlinedCssContentAssistProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offsetInDoc) {
        IDocument doc = viewer.getDocument();
        IStructuredDocument structuredDoc = (IStructuredDocument)doc;
        ITypedRegion partition = SseUtilities.getPartition((IStructuredDocument)structuredDoc, (int)offsetInDoc);
        if (partition == null) {
            GWTPluginLog.logWarning("Could not generate CSS proposals due to problem getting partition of offset.");
            return null;
        }
        int offsetInExtractedDoc = offsetInDoc - partition.getOffset();
        CssExtractor extractor = CssExtractor.extract(doc, partition.getOffset(), partition.getLength(), new CssResourceAwareModelLoader());
        if (extractor == null) {
            GWTPluginLog.logWarning("Could not extract CSS document to generate CSS proposals.");
            return null;
        }
        IndexedRegion indexedNode = extractor.getCssModel().getIndexedRegion(offsetInExtractedDoc);
        if (indexedNode == null) {
            indexedNode = (IndexedRegion)extractor.getCssDocument();
        }
        try {
            ICompletionProposal[] proposals = CssProposalArrangerCaller.getProposals(offsetInExtractedDoc, (ICSSNode)indexedNode, partition.getOffset(), '\u0000');
            ArrayList<IndentationFixingCompletionProposal> newProposals = new ArrayList<IndentationFixingCompletionProposal>();
            ICompletionProposal[] iCompletionProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                newProposals.add(new IndentationFixingCompletionProposal(proposal));
                ++n2;
            }
            return newProposals.toArray(new ICompletionProposal[newProposals.size()]);
        }
        catch (Throwable e) {
            GWTPluginLog.logWarning(e, "Could not generate CSS proposals due to failed call to CSS proposal arranger.");
            return null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

