/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.sse.css;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.sse.css.CssExtractor;
import com.google.gwt.eclipse.core.uibinder.sse.css.ExtractingCssFormattingStrategy;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class InlinedCssFormattingStrategy
extends ExtractingCssFormattingStrategy {
    @Override
    protected String adjustFormattedCssWhitespace(String formattedCssBlock, IDocument document, TypedPosition partition, CssExtractor extractor) {
        try {
            String cssLineSeparator = extractor.getStructuredDocument().getLineDelimiter();
            String xmlLineSeparator = ((IStructuredDocument)document).getLineDelimiter();
            formattedCssBlock = this.indentCssForXml(formattedCssBlock, document, partition, cssLineSeparator, xmlLineSeparator);
            return formattedCssBlock;
        }
        catch (BadLocationException e) {
            GWTPluginLog.logWarning(e, "Could not format CSS block.");
            return null;
        }
    }

    private String computeOneXmlIndentString() {
        char indentChar = ' ';
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("default_catalog");
        String indentCharPref = prefs.get("indentationChar", null);
        if ("tab".equals(indentCharPref)) {
            indentChar = '\t';
        }
        int indentationWidth = prefs.getInt("indentationSize", 0);
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (i < indentationWidth) {
            indent.append(indentChar);
            ++i;
        }
        return indent.toString();
    }

    private String indentCssForXml(String formattedCssBlock, IDocument document, TypedPosition partition, String cssLineSeparator, String xmlLineSeparator) throws BadLocationException {
        String styleElementIndentString;
        String cssBlockIndentString;
        String lineContents;
        int offsetOfNonwhitespaceInLine;
        String oneXmlIndent = this.computeOneXmlIndentString();
        int lineNumberInDocument = document.getLineOfOffset(partition.getOffset());
        int offsetOfLineInDocument = document.getLineOffset(lineNumberInDocument);
        if (offsetOfLineInDocument + (offsetOfNonwhitespaceInLine = StringUtilities.findNonwhitespaceCharacter((String)(lineContents = document.get(offsetOfLineInDocument, document.getLineLength(lineNumberInDocument))), (int)0)) == partition.getOffset()) {
            cssBlockIndentString = lineContents.substring(0, offsetOfNonwhitespaceInLine);
            styleElementIndentString = cssBlockIndentString.replace(oneXmlIndent, "");
        } else {
            styleElementIndentString = lineContents.substring(0, offsetOfNonwhitespaceInLine);
            cssBlockIndentString = String.valueOf(styleElementIndentString) + oneXmlIndent;
        }
        return this.processCssBlock(formattedCssBlock, cssLineSeparator, xmlLineSeparator, cssBlockIndentString, styleElementIndentString);
    }

    private String processCssBlock(String formattedCssBlock, String cssLineSeparator, String xmlLineSeparator, CharSequence cssIndentString, String styleElementIndentString) {
        String[] cssBlockLines = formattedCssBlock.split(Pattern.quote(cssLineSeparator));
        ArrayList<String> processedCssBlockLines = new ArrayList<String>(cssBlockLines.length);
        processedCssBlockLines.add("");
        String[] stringArray = cssBlockLines;
        int n = cssBlockLines.length;
        int n2 = 0;
        while (n2 < n) {
            String curCssLine = stringArray[n2];
            processedCssBlockLines.add(cssIndentString + curCssLine);
            ++n2;
        }
        processedCssBlockLines.add(styleElementIndentString.toString());
        return StringUtilities.join(processedCssBlockLines, (String)xmlLineSeparator);
    }
}

