/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.sse.css;

import com.google.gdt.eclipse.core.SseUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.sse.css.model.CssResourceAwareTokenizer;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.css.ui.internal.style.LineStyleProviderForCSS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class LineStyleProviderForInlinedCss
extends LineStyleProviderForCSS {
    public boolean prepareRegions(ITypedRegion typedRegion, int lineRequestStart, int lineRequestLength, Collection holdResults) {
        List<CSSTextToken> tokens;
        String content;
        ITypedRegion partition = SseUtilities.getPartition((IStructuredDocument)this.getDocument(), (int)typedRegion.getOffset());
        int regionStart = partition.getOffset();
        int regionEnd = regionStart + partition.getLength();
        try {
            content = this.getDocument().get(partition.getOffset(), partition.getLength());
        }
        catch (BadLocationException e1) {
            GWTPluginLog.logWarning(e1, "Unexpected bad location while highlighting a CSS region.");
            return false;
        }
        CssResourceAwareTokenizer t = new CssResourceAwareTokenizer(new StringReader(content));
        try {
            tokens = t.parseText();
        }
        catch (IOException e) {
            return false;
        }
        boolean result = false;
        if (tokens.size() > 0) {
            int start;
            int end = start = regionStart;
            for (CSSTextToken token : tokens) {
                end = start + token.length;
                int styleLength = token.length;
                if (regionStart <= start && start < regionEnd) {
                    if (regionEnd < end) {
                        styleLength = regionEnd - start;
                    }
                    if (this.isContained(typedRegion, start, styleLength)) {
                        this.addStyleRange(holdResults, this.getAttributeFor(token.kind), start, styleLength);
                    }
                } else if (start <= regionStart && regionStart < end) {
                    if (end < regionEnd) {
                        styleLength = end - regionStart;
                    }
                    if (this.isContained(typedRegion, regionStart, styleLength)) {
                        this.addStyleRange(holdResults, this.getAttributeFor(token.kind), regionStart, styleLength);
                    }
                }
                start += token.length;
            }
            result = true;
        }
        return result;
    }

    protected TextAttribute getAttributeFor(ITextRegion region) {
        return null;
    }

    private void addStyleRange(Collection<StyleRange> holdResults, TextAttribute attribute, int start, int end) {
        if (attribute != null) {
            holdResults.add(new StyleRange(start, end, attribute.getForeground(), attribute.getBackground(), attribute.getStyle()));
        } else {
            holdResults.add(new StyleRange(start, end, null, null));
        }
    }

    private boolean isContained(ITypedRegion region, int position, int length) {
        return region.getOffset() <= position && position + length <= region.getOffset() + region.getLength();
    }
}

