/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.sse.css;

import com.google.gdt.eclipse.core.SseUtilities;
import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.sse.css.CssExtractor;
import com.google.gwt.eclipse.core.uibinder.sse.css.model.CssResourceAwareModelLoader;
import com.google.gwt.eclipse.core.uibinder.text.SimpleDocumentCommand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.wst.css.ui.internal.autoedit.StructuredAutoEditStrategyCSS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class StructuredAutoEditStrategyInlinedCss
implements IAutoEditStrategy {
    private static final Pattern NEWLINE_AFTER_OPEN_BRACE = Pattern.compile(".*[{]\\s*\\n\\s*$", 32);
    private final StructuredAutoEditStrategyCSS originalCssAutoEditStrategy = new StructuredAutoEditStrategyCSS();

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.prepareForOriginalCssAutoEditStrategy(document, command)) {
            return;
        }
        IStructuredDocument structuredDoc = (IStructuredDocument)document;
        ITypedRegion region = SseUtilities.getPartition((IStructuredDocument)structuredDoc, (int)command.offset);
        if (region == null) {
            return;
        }
        CssExtractor extractor = CssExtractor.extract(document, region.getOffset(), region.getLength(), new CssResourceAwareModelLoader());
        SimpleDocumentCommand commandForExtractedCss = new SimpleDocumentCommand();
        SimpleDocumentCommand.copyFields(command, commandForExtractedCss, region.getOffset());
        this.originalCssAutoEditStrategy.customizeDocumentCommand((IDocument)extractor.getStructuredDocument(), (DocumentCommand)commandForExtractedCss);
        if (!StringUtilities.equalsIgnoreWhitespace((String)command.text, (String)commandForExtractedCss.text, (boolean)true)) {
            GWTPluginLog.logWarning("Could not correct the indentation, one known cause is conflicting XML and CSS settings for tabs versus spaces, please check your settings.");
            return;
        }
        SimpleDocumentCommand.copyFields(commandForExtractedCss, command, -region.getOffset());
    }

    private boolean checkAndPrepareForNewline(IDocument document, DocumentCommand command) {
        try {
            String documentAndCommandText = String.valueOf(document.get(0, command.offset)) + command.text;
            Matcher matcher = NEWLINE_AFTER_OPEN_BRACE.matcher(documentAndCommandText);
            if (!matcher.matches()) {
                return false;
            }
        }
        catch (BadLocationException e) {
            return false;
        }
        command.text = command.text.replaceAll("\\n\\s+$", "\n");
        return command.text.endsWith("\n");
    }

    private boolean prepareForOriginalCssAutoEditStrategy(IDocument document, DocumentCommand command) {
        if (command.length != 0 || command.text == null) {
            return false;
        }
        return this.checkAndPrepareForNewline(document, command) || command.text.equals("}") || command.text.equals("]") || command.text.equals(")");
    }
}

