/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.sse.css.model;

import com.google.gwt.eclipse.core.GWTPluginLog;
import java.lang.reflect.Method;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.AbstractCssTraverser;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.stylesheets.MediaList;

public class CssResourceAwareModelRepairer {
    private static final String[] EMPTY_MASKED_MEDIA_RULES = new String[]{"@if", "@elif", "@else", "@noflip"};
    private final IStructuredDocument structuredDocument;
    private final ICSSModel cssModel;

    private static void callSetRangeRegion(MediaList mediaList, IStructuredDocumentRegion[] structuredDocumentRegions, ITextRegion textRegion) throws Throwable {
        ClassLoader classLoader = CSSSourceFormatter.class.getClassLoader();
        Class<?> cssRegionContainerClass = classLoader.loadClass("org.eclipse.wst.css.core.internal.document.CSSRegionContainer");
        Method declaredMethod = cssRegionContainerClass.getDeclaredMethod("setRangeRegion", IStructuredDocumentRegion.class, ITextRegion.class, ITextRegion.class);
        declaredMethod.setAccessible(true);
        declaredMethod.invoke((Object)mediaList, structuredDocumentRegions[0], textRegion, textRegion);
    }

    public CssResourceAwareModelRepairer(IStructuredDocument structuredDocument, ICSSModel cssModel) {
        this.structuredDocument = structuredDocument;
        this.cssModel = cssModel;
    }

    public void repair() {
        new MyCssTraverser().apply(this.cssModel);
    }

    private boolean containsEmptyMaskedMediaRule(CSSMediaRule mediaRule, IndexedRegion mediaRuleRegion) {
        String[] stringArray = EMPTY_MASKED_MEDIA_RULES;
        int n = EMPTY_MASKED_MEDIA_RULES.length;
        int n2 = 0;
        while (n2 < n) {
            String rule = stringArray[n2];
            try {
                if (this.structuredDocument.getLength() >= rule.length() && rule.equalsIgnoreCase(this.structuredDocument.get(mediaRuleRegion.getStartOffset(), rule.length())) && mediaRule.getMedia().getLength() <= 0) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++n2;
        }
        return false;
    }

    private void fixPotentialEmptyMaskedMediaRule(ICSSNode node) {
        CSSMediaRule mediaRule = (CSSMediaRule)node;
        IndexedRegion mediaRuleRegion = (IndexedRegion)mediaRule;
        if (!this.containsEmptyMaskedMediaRule(mediaRule, mediaRuleRegion)) {
            return;
        }
        MediaList mediaList = mediaRule.getMedia();
        IStructuredDocumentRegion[] structuredDocumentRegions = this.structuredDocument.getStructuredDocumentRegions(mediaRuleRegion.getStartOffset(), mediaRuleRegion.getLength());
        ContextRegion textRegion = new ContextRegion("MEDIUM", structuredDocumentRegions[0].getEndOffset() - structuredDocumentRegions[0].getStartOffset(), 0, 0);
        try {
            CssResourceAwareModelRepairer.callSetRangeRegion(mediaList, structuredDocumentRegions, (ITextRegion)textRegion);
        }
        catch (Throwable e) {
            GWTPluginLog.logError(e, "Could not clean up the @else in the CSS model.");
        }
    }

    private class MyCssTraverser
    extends AbstractCssTraverser {
        private MyCssTraverser() {
        }

        protected short preNode(ICSSNode node) {
            if (node.getNodeType() == 4) {
                CssResourceAwareModelRepairer.this.fixPotentialEmptyMaskedMediaRule(node);
            }
            return TRAV_CONT;
        }
    }
}

