/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.text;

import com.google.gwt.eclipse.core.uibinder.text.MockDocument;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class CompletionProposalTextCapturer {
    public static List<CapturedText> capture(ICompletionProposal proposal) throws CapturingFailedException {
        CapturingDocument capturingDocument = new CapturingDocument();
        try {
            proposal.apply((IDocument)capturingDocument);
        }
        catch (MockDocument.UnsupportedMockOperationException e) {
            throw new CapturingFailedException("Could not capture the text of the given proposal.", e);
        }
        return capturingDocument.getCapturedText();
    }

    public static class CapturedText {
        private final int offset;
        private final int length;
        private final String text;

        public CapturedText(int offset, int length, String text) {
            this.offset = offset;
            this.length = length;
            this.text = text;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getText() {
            return this.text;
        }
    }

    private static class CapturingDocument
    extends MockDocument {
        private final List<CapturedText> capturedText = new ArrayList<CapturedText>();

        private CapturingDocument() {
        }

        public List<CapturedText> getCapturedText() {
            return this.capturedText;
        }

        @Override
        public void replace(int offset, int length, String text) throws BadLocationException {
            this.capturedText.add(new CapturedText(offset, length, text));
        }
    }

    public static class CapturingFailedException
    extends Exception {
        public CapturingFailedException(String message) {
            super(message);
        }

        public CapturingFailedException(String msg, Throwable e) {
            super(msg, e);
        }
    }
}

