/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.text;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.text.CompletionProposalTextCapturer;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class IndentationFixingCompletionProposal
implements ICompletionProposal {
    private static final int CURSOR_POSITION_NOT_SET = -1;
    private final ICompletionProposal originalProposal;
    private int cursorPosition = -1;

    public IndentationFixingCompletionProposal(ICompletionProposal originalProposal) {
        this.originalProposal = originalProposal;
    }

    public void apply(IDocument document) {
        try {
            List<CompletionProposalTextCapturer.CapturedText> capturedTextList = CompletionProposalTextCapturer.capture(this.originalProposal);
            if (capturedTextList.size() != 1) {
                throw new CompletionProposalTextCapturer.CapturingFailedException(String.format("Expecting 1 captured text, got %1$d", capturedTextList.size()));
            }
            CompletionProposalTextCapturer.CapturedText capturedText = capturedTextList.get(0);
            int line = document.getLineOfOffset(capturedText.getOffset());
            String lineDelimiter = document.getLineDelimiter(line);
            if (lineDelimiter == null) {
                this.originalProposal.apply(document);
                return;
            }
            String lineText = document.get(document.getLineOffset(line), document.getLineLength(line) - lineDelimiter.length());
            int firstCharOffsetInLine = StringUtilities.findNonwhitespaceCharacter((String)lineText, (int)0);
            String indentationString = lineText.substring(0, firstCharOffsetInLine);
            String lineDelimiterAndIndentationString = String.valueOf(lineDelimiter) + indentationString;
            String newProposalText = capturedText.getText().replaceAll(Pattern.quote(lineDelimiter), lineDelimiterAndIndentationString);
            if (newProposalText.endsWith(lineDelimiterAndIndentationString)) {
                newProposalText = newProposalText.substring(0, newProposalText.lastIndexOf(indentationString));
            }
            document.replace(capturedText.getOffset(), capturedText.getLength(), newProposalText);
            Point originalSelection = this.originalProposal.getSelection(document);
            if (originalSelection != null) {
                int lineOfCursor = new Document(capturedText.getText()).getLineOfOffset(originalSelection.x - capturedText.getOffset());
                this.cursorPosition = originalSelection.x + lineOfCursor * indentationString.length();
            }
        }
        catch (BadLocationException e) {
            GWTPluginLog.logWarning(e, "The indentation of the completion proposal could not be fixed, applying anyway.");
            this.originalProposal.apply(document);
        }
        catch (CompletionProposalTextCapturer.CapturingFailedException e) {
            GWTPluginLog.logWarning(e, "The indentation of the completion proposal could not be fixed, applying anyway.");
            this.originalProposal.apply(document);
        }
    }

    public String getAdditionalProposalInfo() {
        return this.originalProposal.getAdditionalProposalInfo();
    }

    public IContextInformation getContextInformation() {
        return this.originalProposal.getContextInformation();
    }

    public String getDisplayString() {
        return this.originalProposal.getDisplayString();
    }

    public Image getImage() {
        return this.originalProposal.getImage();
    }

    public Point getSelection(IDocument document) {
        if (this.cursorPosition == -1) {
            return this.originalProposal.getSelection(document);
        }
        return new Point(this.cursorPosition, 0);
    }
}

