/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.text;

import com.google.gdt.eclipse.core.formatter.IDocumentCloner;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.text.IDocumentPartitionerFactory;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class StructuredDocumentCloner
implements IDocumentCloner {
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private final IDocumentPartitionerFactory documentPartitionerFactory;
    private final Map<IDocument, IStructuredModel> modelClones = new WeakHashMap<IDocument, IStructuredModel>();
    private final String partitioning;

    public StructuredDocumentCloner(String partitioning, IDocumentPartitionerFactory documentPartitionerFactory) {
        this.partitioning = partitioning;
        this.documentPartitionerFactory = documentPartitionerFactory;
    }

    public IStructuredDocument clone(IDocument original) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        String modelId = this.getModelId(original);
        if (modelId == null) {
            GWTPluginLog.logError("Could not get a model ID for the document to be formatted.");
            return null;
        }
        try {
            IStructuredModel modelClone = modelManager.copyModelForEdit(modelId, "structuredDocumentClonerModel" + nextId.getAndIncrement());
            modelClone.setBaseLocation(this.getModelBaseLocation(original));
            IStructuredDocument documentClone = modelClone.getStructuredDocument();
            documentClone.set(original.get());
            IDocumentPartitioner tempPartitioner = this.documentPartitionerFactory.createDocumentPartitioner();
            ((IDocumentExtension3)documentClone).setDocumentPartitioner(this.partitioning, tempPartitioner);
            tempPartitioner.connect((IDocument)documentClone);
            this.modelClones.put((IDocument)documentClone, modelClone);
            return documentClone;
        }
        catch (ResourceInUse e1) {
            GWTPluginLog.logError(e1, "Could not copy the original model to be formatted.");
            return null;
        }
    }

    public void release(IDocument clone) {
        IStructuredModel model = this.modelClones.get(clone);
        if (model != null) {
            model.releaseFromEdit();
        }
    }

    private String getModelBaseLocation(IDocument document) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = modelManager.getExistingModelForRead(document);
            String string = model.getBaseLocation();
            return string;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private String getModelId(IDocument document) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = modelManager.getExistingModelForRead(document);
            String string = model.getId();
            return string;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }
}

