/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.validators;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.SseUtilities;
import com.google.gdt.eclipse.core.java.ClasspathResourceUtilities;
import com.google.gdt.eclipse.core.reference.IReference;
import com.google.gdt.eclipse.core.reference.Reference;
import com.google.gdt.eclipse.core.reference.ReferenceManager;
import com.google.gdt.eclipse.core.reference.location.ClasspathRelativeFileReferenceLocation;
import com.google.gdt.eclipse.core.reference.location.IReferenceLocation;
import com.google.gdt.eclipse.core.reference.location.LogicalJavaElementReferenceLocation;
import com.google.gdt.eclipse.core.reference.location.ReferenceLocationType;
import com.google.gdt.eclipse.core.reference.logicaljavamodel.ILogicalJavaElement;
import com.google.gdt.eclipse.core.reference.logicaljavamodel.LogicalType;
import com.google.gdt.eclipse.core.validation.ValidationResult;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.UiBinderUtilities;
import com.google.gwt.eclipse.core.uibinder.model.UiBinderSubtypeToOwnerIndex;
import com.google.gwt.eclipse.core.uibinder.model.UiBinderSubtypeToUiXmlIndex;
import com.google.gwt.eclipse.core.uibinder.model.UiXmlReferencedFieldIndex;
import com.google.gwt.eclipse.core.uibinder.model.reference.UiBinderXmlParser;
import com.google.gwt.eclipse.core.uibinder.problems.MarkerPlacementStrategy;
import com.google.gwt.eclipse.core.uibinder.problems.java.UiBinderJavaProblem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class UiBinderJavaValidator {
    private final CompilationUnit cu;
    private final IJavaProject javaProject;
    private final UiBinderSubtypeToUiXmlIndex ownerToUiXml;
    private final ReferenceManager referenceManager;
    private ValidationResult result;
    private final UiBinderSubtypeToOwnerIndex uiBinderToOwner;
    private final UiXmlReferencedFieldIndex uiXmlFieldRefs;

    private static ITypeBinding getOwnerTypeBinding(TypeDeclaration uiBinderSubtype) {
        List superInterfaces = uiBinderSubtype.superInterfaceTypes();
        for (Type superInterface : superInterfaces) {
            ParameterizedType uiBinderType;
            List typeArgs;
            ITypeBinding binding = superInterface.resolveBinding();
            if (binding == null || !binding.getErasure().getQualifiedName().equals("com.google.gwt.uibinder.client.UiBinder") || !(superInterface instanceof ParameterizedType) || (typeArgs = (uiBinderType = (ParameterizedType)superInterface).typeArguments()).size() != 2) continue;
            Type ownerType = (Type)typeArgs.get(1);
            return ownerType.resolveBinding();
        }
        return null;
    }

    private static IType getType(TypeDeclaration typeDecl) {
        if (typeDecl == null) {
            return null;
        }
        ITypeBinding typeBinding = typeDecl.resolveBinding();
        if (typeBinding == null) {
            return null;
        }
        IJavaElement javaElement = typeBinding.getJavaElement();
        return javaElement instanceof IType ? (IType)javaElement : null;
    }

    private static boolean isUiBinder(ITypeBinding typeBinding) {
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding superInterface = iTypeBindingArray[n2];
            if (superInterface.getErasure().getQualifiedName().equals("com.google.gwt.uibinder.client.UiBinder")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public UiBinderJavaValidator(CompilationUnit cu, UiBinderSubtypeToOwnerIndex uiBinderToOwner, UiBinderSubtypeToUiXmlIndex ownerToUiXml, UiXmlReferencedFieldIndex uiXmlFieldRefs, ReferenceManager referenceManager) {
        this.cu = cu;
        this.javaProject = JavaASTUtils.getCompilationUnit((ASTNode)cu).getJavaProject();
        this.uiBinderToOwner = uiBinderToOwner;
        this.ownerToUiXml = ownerToUiXml;
        this.uiXmlFieldRefs = uiXmlFieldRefs;
        this.referenceManager = referenceManager;
    }

    public ValidationResult validate() {
        this.result = new ValidationResult();
        this.cu.accept((ASTVisitor)new UiBinderSubtypeVisitor());
        this.cu.accept((ASTVisitor)new UiBinderOwnerVisitor());
        return this.result;
    }

    private class UiBinderOwnerVisitor
    extends ASTVisitor {
        private static final String SUPPRESS_WARNINGS_UIBINDER = "uibinder";

        private UiBinderOwnerVisitor() {
        }

        public boolean visit(TypeDeclaration typeDecl) {
            if (!this.shouldValidateType(typeDecl)) {
                return true;
            }
            for (IType uiBinderType : UiBinderJavaValidator.this.uiBinderToOwner.getUiBinderTypes(typeDecl.resolveBinding().getQualifiedName())) {
                UiBinderJavaValidator.this.result.addTypeDependency(uiBinderType.getFullyQualifiedName());
            }
            FieldDeclaration[] fieldDeclarationArray = typeDecl.getFields();
            int n = fieldDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldDeclaration field = fieldDeclarationArray[n2];
                if (UiBinderUtilities.isUiField(field)) {
                    this.validateUiField(field);
                }
                ++n2;
            }
            fieldDeclarationArray = typeDecl.getMethods();
            n = fieldDeclarationArray.length;
            n2 = 0;
            while (n2 < n) {
                FieldDeclaration method = fieldDeclarationArray[n2];
                if (UiBinderUtilities.isUiHandler((MethodDeclaration)method)) {
                    this.validateUiHandler((MethodDeclaration)method);
                }
                ++n2;
            }
            return true;
        }

        private Set<IPath> getUiXmlWorkspaceRelativePaths(TypeDeclaration ownerTypeDecl) {
            HashSet<IPath> paths = new HashSet<IPath>();
            String ownerTypeName = ownerTypeDecl.resolveBinding().getQualifiedName();
            for (IType uiBinderSubtype : UiBinderJavaValidator.this.uiBinderToOwner.getUiBinderTypes(ownerTypeName)) {
                IPath uiXmlClasspathRelativePath = UiBinderJavaValidator.this.ownerToUiXml.getUiXmlPath(uiBinderSubtype);
                try {
                    IStorage uiXmlFile = ClasspathResourceUtilities.resolveFile((IPath)uiXmlClasspathRelativePath, (IJavaProject)UiBinderJavaValidator.this.javaProject);
                    if (!(uiXmlFile instanceof IFile)) continue;
                    paths.add(uiXmlFile.getFullPath());
                }
                catch (JavaModelException e) {
                    GWTPluginLog.logError(e);
                }
            }
            return paths;
        }

        private boolean shouldValidateType(TypeDeclaration typeDecl) {
            if (typeDecl.isInterface()) {
                return false;
            }
            IType ownerType = UiBinderJavaValidator.getType(typeDecl);
            if (ownerType == null) {
                return false;
            }
            if (!UiBinderJavaValidator.this.uiBinderToOwner.isOwnerType(ownerType.getFullyQualifiedName('.'))) {
                return false;
            }
            if (typeDecl.resolveBinding() == null) {
                GWTPluginLog.logWarning("Could not resolve binding for " + typeDecl.getName().getFullyQualifiedName());
                return false;
            }
            return true;
        }

        private void validateFieldExistenceInUiXml(TypeDeclaration ownerTypeDecl, ASTNode problemNode, String fieldName) {
            for (IPath uiXmlPath : this.getUiXmlWorkspaceRelativePaths(ownerTypeDecl)) {
                if (UiBinderJavaValidator.this.uiXmlFieldRefs.isFieldReferencedByUiXml(uiXmlPath, fieldName)) continue;
                UiBinderJavaValidator.this.result.addProblem((CategorizedProblem)UiBinderJavaProblem.createMissingUiFieldInXml(problemNode, fieldName, uiXmlPath));
            }
        }

        private void validateUiField(FieldDeclaration uiFieldDecl) {
            if (JavaASTUtils.hasSuppressWarnings((BodyDeclaration)uiFieldDecl, (String)SUPPRESS_WARNINGS_UIBINDER)) {
                return;
            }
            this.validateUiFieldVisibility(uiFieldDecl);
            this.validateUiFieldExistenceInUiXml(uiFieldDecl);
        }

        private void validateUiFieldExistenceInUiXml(FieldDeclaration uiFieldDecl) {
            List varDecls = uiFieldDecl.fragments();
            for (VariableDeclarationFragment varDecl : varDecls) {
                SimpleName fieldNameDecl = varDecl.getName();
                this.validateFieldExistenceInUiXml((TypeDeclaration)uiFieldDecl.getParent(), (ASTNode)fieldNameDecl, fieldNameDecl.getIdentifier());
            }
        }

        private void validateUiFieldVisibility(FieldDeclaration uiFieldDecl) {
            Modifier privateModifier = JavaASTUtils.findPrivateModifier((BodyDeclaration)uiFieldDecl);
            if (privateModifier != null) {
                UiBinderJavaValidator.this.result.addAllProblems(UiBinderJavaProblem.createPrivateUiField(uiFieldDecl, privateModifier));
            }
        }

        private void validateUiHandler(MethodDeclaration uiHandlerDecl) {
            if (JavaASTUtils.hasSuppressWarnings((BodyDeclaration)uiHandlerDecl, (String)SUPPRESS_WARNINGS_UIBINDER)) {
                return;
            }
            this.validateUiHandlerVisibility(uiHandlerDecl);
            this.validateUiHandlerFieldExistenceInUiXml(uiHandlerDecl);
        }

        private void validateUiHandlerFieldExistenceInUiXml(MethodDeclaration uiHandlerDecl) {
            Annotation annotation = JavaASTUtils.findAnnotation((BodyDeclaration)uiHandlerDecl, (String)"com.google.gwt.uibinder.client.UiHandler");
            if (annotation instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation uiHandlerAnnotation = (SingleMemberAnnotation)annotation;
                Expression exp = uiHandlerAnnotation.getValue();
                if (exp instanceof StringLiteral) {
                    this.validateFieldExistenceInUiXml((TypeDeclaration)uiHandlerDecl.getParent(), (ASTNode)exp, ((StringLiteral)exp).getLiteralValue());
                } else if (exp instanceof ArrayInitializer) {
                    for (Expression element : ((ArrayInitializer)exp).expressions()) {
                        if (!(element instanceof StringLiteral)) continue;
                        this.validateFieldExistenceInUiXml((TypeDeclaration)uiHandlerDecl.getParent(), (ASTNode)element, ((StringLiteral)element).getLiteralValue());
                    }
                }
            }
        }

        private void validateUiHandlerVisibility(MethodDeclaration uiHandlerDecl) {
            Modifier privateModifier = JavaASTUtils.findPrivateModifier((BodyDeclaration)uiHandlerDecl);
            if (privateModifier != null) {
                UiBinderJavaValidator.this.result.addProblem((CategorizedProblem)UiBinderJavaProblem.createPrivateUiHandler(uiHandlerDecl, privateModifier));
            }
        }
    }

    private class UiBinderSubtypeVisitor
    extends ASTVisitor {
        private UiBinderSubtypeVisitor() {
        }

        public boolean visit(TypeDeclaration typeDecl) {
            if (!this.shouldValidateType(typeDecl)) {
                return true;
            }
            this.validateUiXmlExistence(typeDecl);
            this.validateTypeVisibility(typeDecl);
            if (UiBinderJavaValidator.this.referenceManager != null) {
                this.parseAndValidateUiXml(UiBinderJavaValidator.getType(typeDecl), UiBinderJavaValidator.this.referenceManager);
            }
            IType uiBinderType = UiBinderJavaValidator.getType(typeDecl);
            ITypeBinding ownerTypeBinding = UiBinderJavaValidator.getOwnerTypeBinding(typeDecl);
            if (uiBinderType != null && ownerTypeBinding != null) {
                UiBinderJavaValidator.this.uiBinderToOwner.setOwnerType(uiBinderType, ownerTypeBinding.getQualifiedName());
            }
            return true;
        }

        private void parseAndValidateUiXml(IType uiBinderSubtype, ReferenceManager referenceManager) {
            try {
                IPath uiXmlPath = UiBinderJavaValidator.this.ownerToUiXml.getUiXmlPath(uiBinderSubtype);
                IStorage uiXmlFileAsObj = ClasspathResourceUtilities.resolveFile((IPath)uiXmlPath, (IJavaProject)UiBinderJavaValidator.this.javaProject);
                if (!(uiXmlFileAsObj instanceof IFile)) {
                    return;
                }
                IDOMModel uiXmlModel = null;
                try {
                    IFile uiXmlFile = (IFile)uiXmlFileAsObj;
                    uiXmlModel = SseUtilities.getModelForRead((IResource)uiXmlFile);
                    if (uiXmlModel == null) {
                        GWTPluginLog.logWarning("Could not find a corresponding model for " + uiXmlPath);
                        return;
                    }
                    UiBinderXmlParser.ParseResults parseResults = UiBinderXmlParser.newInstance(uiXmlModel, referenceManager, new MarkerPlacementStrategy("com.gwtplugins.gwt.eclipse.core.uiBinderProblemMarker")).parse();
                    if (parseResults == null) {
                        return;
                    }
                    UiBinderJavaValidator.this.result.addAllTypeDependencies(parseResults.getJavaTypeReferences());
                    UiBinderJavaValidator.this.uiXmlFieldRefs.putFieldReferencesForUiXml(uiXmlFile.getFullPath(), parseResults.getFieldNames());
                }
                finally {
                    if (uiXmlModel != null) {
                        uiXmlModel.releaseFromRead();
                    }
                }
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                GWTPluginLog.logError(e);
            }
            catch (CoreException e) {
                GWTPluginLog.logError(e);
            }
            catch (UiBinderException e) {
                GWTPluginLog.logError(e);
            }
        }

        private boolean shouldValidateType(TypeDeclaration typeDecl) {
            if (!typeDecl.isInterface()) {
                return false;
            }
            ITypeBinding typeBinding = typeDecl.resolveBinding();
            if (typeBinding == null) {
                return false;
            }
            return UiBinderJavaValidator.isUiBinder(typeBinding);
        }

        private void validateTypeVisibility(TypeDeclaration uiBinderSubtypeDecl) {
            Modifier privateModifier = JavaASTUtils.findPrivateModifier((BodyDeclaration)uiBinderSubtypeDecl);
            if (privateModifier != null) {
                UiBinderJavaValidator.this.result.addProblem((CategorizedProblem)UiBinderJavaProblem.createPrivateUiBinderSubtype(uiBinderSubtypeDecl, privateModifier));
            }
        }

        private void validateUiXmlExistence(IPath uiXmlPath, ASTNode node) {
            try {
                TypeDeclaration uiBinderSubtypeDecl = (TypeDeclaration)JavaASTUtils.findAncestor((ASTNode)node, TypeDeclaration.class);
                IType uiBinderSubtype = UiBinderJavaValidator.getType(uiBinderSubtypeDecl);
                if (uiBinderSubtype != null) {
                    UiBinderJavaValidator.this.ownerToUiXml.setUiXmlPath(uiBinderSubtype, uiXmlPath);
                    if (UiBinderJavaValidator.this.referenceManager != null) {
                        UiBinderJavaValidator.this.referenceManager.removeReferences((Collection)UiBinderJavaValidator.this.referenceManager.getReferencesWithMatchingJavaElement((IJavaElement)uiBinderSubtype, EnumSet.of(ReferenceLocationType.SOURCE)));
                        LogicalType uiBinderSubtypeLogicalType = new LogicalType(uiBinderSubtype);
                        LogicalJavaElementReferenceLocation uiBinderSubtypeRefLocation = new LogicalJavaElementReferenceLocation((ILogicalJavaElement)uiBinderSubtypeLogicalType);
                        ClasspathRelativeFileReferenceLocation uiXmlRefLocation = new ClasspathRelativeFileReferenceLocation(uiXmlPath);
                        UiBinderJavaValidator.this.referenceManager.addReference((IReference)new Reference((IReferenceLocation)uiBinderSubtypeRefLocation, (IReferenceLocation)uiXmlRefLocation, uiBinderSubtype.getJavaProject().getProject()));
                    }
                }
                if (!ClasspathResourceUtilities.isResourceOnClasspath((IJavaProject)UiBinderJavaValidator.this.javaProject, (IPath)uiXmlPath)) {
                    UiBinderJavaValidator.this.result.addProblem((CategorizedProblem)UiBinderJavaProblem.createMissingUiXmlFile(node, uiXmlPath.lastSegment(), uiXmlPath.removeLastSegments(1)));
                }
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e, "Error while searching for {0} in project {1}", uiXmlPath.toString(), UiBinderJavaValidator.this.javaProject.getElementName());
            }
        }

        private void validateUiXmlExistence(TypeDeclaration uiBinderSubtypeDecl) {
            ITypeBinding typeBinding = uiBinderSubtypeDecl.resolveBinding();
            Annotation annotation = JavaASTUtils.findAnnotation((BodyDeclaration)uiBinderSubtypeDecl, (String)"com.google.gwt.uibinder.client.UiTemplate");
            if (annotation instanceof SingleMemberAnnotation || annotation instanceof NormalAnnotation) {
                List values;
                SingleMemberAnnotation uiTemplateAnnotation;
                Expression exp = null;
                if (annotation instanceof SingleMemberAnnotation) {
                    uiTemplateAnnotation = (SingleMemberAnnotation)annotation;
                    exp = uiTemplateAnnotation.getValue();
                } else if (annotation instanceof NormalAnnotation && (values = (uiTemplateAnnotation = (NormalAnnotation)annotation).values()).size() == 1) {
                    exp = ((MemberValuePair)values.get(0)).getValue();
                }
                if (exp instanceof StringLiteral) {
                    String uiTemplateValue = ((StringLiteral)exp).getLiteralValue();
                    IPath explicitUiXmlPath = new Path(typeBinding.getPackage().getName().replace('.', '/')).append(uiTemplateValue);
                    this.validateUiXmlExistence(explicitUiXmlPath, (ASTNode)exp);
                }
            } else {
                TypeDeclaration enclosingType = JavaASTUtils.getEnclosingType((TypeDeclaration)uiBinderSubtypeDecl);
                if (enclosingType != null) {
                    typeBinding = enclosingType.resolveBinding();
                }
                String uiXmlFileName = String.valueOf(typeBinding.getName()) + ".ui.xml";
                Path implicitUiXmlPath = new Path(typeBinding.getErasure().getQualifiedName().replace('.', '/'));
                implicitUiXmlPath = implicitUiXmlPath.removeLastSegments(1).append(uiXmlFileName);
                this.validateUiXmlExistence((IPath)implicitUiXmlPath, (ASTNode)uiBinderSubtypeDecl.getName());
            }
        }
    }
}

