/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.uibinder.validators;

import com.google.gwt.eclipse.core.uibinder.UiBinderException;
import com.google.gwt.eclipse.core.uibinder.model.reference.UiBinderXmlParser;
import com.google.gwt.eclipse.core.uibinder.problems.ReporterMessagePlacementStrategy;
import java.io.FileNotFoundException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.validation.MarkupValidator;

public class UiXmlEditorValidator
extends MarkupValidator {
    private IDocument document;
    private int documentRefCount;

    public void connect(IDocument document) {
        super.connect(document);
        this.document = document;
        ++this.documentRefCount;
    }

    public void disconnect(IDocument document) {
        super.disconnect(document);
        if (this.documentRefCount > 0) {
            --this.documentRefCount;
        }
        if (this.documentRefCount == 0) {
            this.document = null;
        }
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        super.validate(helper, reporter);
        if (this.document == null) {
            return;
        }
        IDOMModel xmlModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
        if (xmlModel != null) {
            try {
                try {
                    ReporterMessagePlacementStrategy validationResultPlacementStrategy = new ReporterMessagePlacementStrategy((IValidator)this, reporter);
                    validationResultPlacementStrategy.setClearAllowed(false);
                    UiBinderXmlParser.newInstance(xmlModel, null, validationResultPlacementStrategy).parse();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    xmlModel.releaseFromRead();
                }
                catch (UiBinderException uiBinderException) {
                    xmlModel.releaseFromRead();
                }
            }
            finally {
                xmlModel.releaseFromRead();
            }
        }
    }
}

