/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.util;

import com.google.gdt.eclipse.core.sdk.SdkUtils;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import org.eclipse.jdt.core.IJavaProject;

public class GwtVersionUtil {
    public static boolean isGwtVersionKnownAndAtLeast25(String directoryName) {
        if (!directoryName.startsWith("gwt-")) {
            return false;
        }
        return SdkUtils.compareVersionStrings((String)directoryName.substring(4), (String)"2.5.0") >= 0;
    }

    public static boolean isGwtVersionlessThan25(IJavaProject javaProject) {
        String gwtVersionCompareTo = "2.5.0";
        String gwtVersionCurrentProject = GwtVersionUtil.getProjectGwtVersion(javaProject);
        int comparison = SdkUtils.compareVersionStrings((String)gwtVersionCurrentProject, (String)gwtVersionCompareTo);
        return comparison < 0;
    }

    public static boolean isGwtVersionGreaterOrEqualTo27(IJavaProject javaProject) {
        String gwtVersionCompareTo = "2.7.0";
        String gwtVersionCurrentProject = GwtVersionUtil.getProjectGwtVersion(javaProject);
        int comparison = SdkUtils.compareVersionStrings((String)gwtVersionCompareTo, (String)gwtVersionCurrentProject);
        return comparison >= 0;
    }

    public static String getProjectGwtVersion(IJavaProject javaProject) {
        GwtSdk sdk = GwtSdk.findSdkFor(javaProject);
        String version = "999.999.999";
        if (sdk != null) {
            version = sdk.getVersion();
        } else {
            GWTPluginLog.logWarning("GWT SDK not found");
        }
        return version;
    }
}

