/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.util;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gwt.eclipse.core.GWTPluginLog;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;

public final class Util {
    public static final String PLATFORM_LINUX = "linux";
    public static final String PLATFORM_MAC = "mac";
    public static final String PLATFORM_WINDOWS = "windows";
    public static final List<String> VALID_ASYNC_RPC_RETURN_TYPES = Arrays.asList("void", "com.google.gwt.http.client.Request", "com.google.gwt.http.client.RequestBuilder");

    public static Type computeSyncReturnType(AST ast, MethodDeclaration asyncMethod, ImportRewrite imports) {
        PrimitiveType returnType = ast.newPrimitiveType(PrimitiveType.VOID);
        List asyncParameters = asyncMethod.parameters();
        if (asyncParameters.isEmpty()) {
            return returnType;
        }
        Type callbackType = ((SingleVariableDeclaration)asyncParameters.get(asyncParameters.size() - 1)).getType();
        if (callbackType.isParameterizedType()) {
            List callbackTypeArgs;
            ParameterizedType callbackParamType = (ParameterizedType)callbackType;
            ITypeBinding callbackBinding = callbackParamType.getType().resolveBinding();
            if (callbackBinding == null) {
                return returnType;
            }
            String callbackBaseTypeName = callbackBinding.getErasure().getQualifiedName();
            if (callbackBaseTypeName.equals("com.google.gwt.user.client.rpc.AsyncCallback") && (callbackTypeArgs = callbackParamType.typeArguments()).size() == 1) {
                Type callbackTypeParameter = (Type)callbackTypeArgs.get(0);
                String qualifiedName = callbackTypeParameter.resolveBinding().getQualifiedName();
                String primitiveTypeName = JavaASTUtils.getPrimitiveTypeName((String)qualifiedName);
                if (primitiveTypeName != null) {
                    return ast.newPrimitiveType(PrimitiveType.toCode((String)primitiveTypeName));
                }
                returnType = JavaASTUtils.normalizeTypeAndAddImport((AST)ast, (Type)callbackTypeParameter, (ImportRewrite)imports);
            }
        }
        return returnType;
    }

    public static SingleVariableDeclaration createAsyncCallbackParameter(AST ast, Type syncReturnType, String callbackParameterName, ImportRewrite imports) {
        ITypeBinding syncReturnTypeBinding = syncReturnType.resolveBinding();
        SingleVariableDeclaration parameter = ast.newSingleVariableDeclaration();
        String gwtCallbackTypeSig = Signature.createTypeSignature((String)"com.google.gwt.user.client.rpc.AsyncCallback", (boolean)true);
        Type gwtCallbackType = imports.addImportFromSignature(gwtCallbackTypeSig, ast);
        if (syncReturnTypeBinding.isPrimitive()) {
            String wrapperName = JavaASTUtils.getWrapperTypeName((String)syncReturnTypeBinding.getName());
            String wrapperTypeSig = Signature.createTypeSignature((String)wrapperName, (boolean)true);
            syncReturnType = imports.addImportFromSignature(wrapperTypeSig, ast);
        } else {
            syncReturnType = JavaASTUtils.normalizeTypeAndAddImport((AST)ast, (Type)syncReturnType, (ImportRewrite)imports);
        }
        ParameterizedType type = ast.newParameterizedType(gwtCallbackType);
        List typeArgs = type.typeArguments();
        typeArgs.add(syncReturnType);
        parameter.setType((Type)type);
        parameter.setName(ast.newSimpleName(callbackParameterName));
        return parameter;
    }

    public static IPath findSourcesJarForClassesJar(IPath jarPath) {
        String jarName = jarPath.lastSegment();
        int indexOfJarExtension = jarName.lastIndexOf(".jar");
        if (indexOfJarExtension > -1) {
            String sourceJarName = String.valueOf(jarName.substring(0, indexOfJarExtension)) + "-sources.jar";
            IPath sourceJarPath = jarPath.removeLastSegments(1).append(sourceJarName);
            if (sourceJarPath.toFile().exists()) {
                return sourceJarPath;
            }
        }
        return null;
    }

    public static IPath getAbsoluteFileSystemPath(IPath workspaceRelativePath) {
        assert (workspaceRelativePath.segmentCount() > 0);
        String projectName = workspaceRelativePath.segment(0);
        IProject project = Util.getWorkspaceRoot().getProject(projectName);
        assert (project.exists());
        IPath projectFileSystemPath = project.getLocation();
        IPath projectRelativePath = workspaceRelativePath.removeFirstSegments(1);
        return projectFileSystemPath.append(projectRelativePath);
    }

    public static SingleVariableDeclaration getCallbackParameter(MethodDeclaration method) {
        List asyncParameters = method.parameters();
        if (asyncParameters.isEmpty()) {
            return null;
        }
        SingleVariableDeclaration callback = (SingleVariableDeclaration)asyncParameters.get(asyncParameters.size() - 1);
        ITypeBinding callbackBinding = callback.getType().resolveBinding();
        if (callbackBinding == null) {
            return null;
        }
        String callbackBaseTypeName = callbackBinding.getErasure().getQualifiedName();
        if ("com.google.gwt.user.client.rpc.AsyncCallback".equals(callbackBaseTypeName)) {
            return callback;
        }
        return null;
    }

    public static String getDevJarName(IPath sdkLocation) {
        IPath devJarPath = sdkLocation.append("gwt-dev.jar");
        if (devJarPath.toFile().exists()) {
            return devJarPath.lastSegment();
        }
        return "gwt-dev-" + Util.getPlatformName() + ".jar";
    }

    public static String getPlatformName() {
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            return PLATFORM_WINDOWS;
        }
        if ("macosx".equals(os)) {
            return PLATFORM_MAC;
        }
        if (PLATFORM_LINUX.equals(os)) {
            return PLATFORM_LINUX;
        }
        return os;
    }

    public static IProject getProject(IPath workspaceRelativePath) {
        IFile file = Util.getWorkspaceRoot().getFile(workspaceRelativePath);
        if (!file.exists()) {
            return null;
        }
        return file.getProject();
    }

    public static String[] getValidationJarNames(IPath sdkLocation) {
        File sdkDir = sdkLocation.toFile();
        if (!sdkDir.exists()) {
            return null;
        }
        String[] validationJarNames = sdkDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String fileName) {
                return fileName.startsWith("validation-api-") && fileName.endsWith(".jar") && file.exists();
            }
        });
        return validationJarNames;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static boolean isPlatformMac() {
        return PLATFORM_MAC.equals(Util.getPlatformName());
    }

    public static boolean isValidMethodName(String methodName) {
        String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return JavaConventions.validateMethodName((String)methodName, (String)sourceLevel, (String)complianceLevel).isOK();
    }

    public static boolean isValidPackageName(String packageName) {
        return !Util.validatePackageName(packageName).matches(4);
    }

    public static boolean isValidTypeName(String typeName) {
        String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return JavaConventions.validateJavaTypeName((String)typeName, (String)sourceLevel, (String)complianceLevel).isOK();
    }

    public static String join(Iterable<?> items, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator<?> iter = items.iterator();
        if (iter.hasNext()) {
            buffer.append(iter.next().toString());
            while (iter.hasNext()) {
                buffer.append(delimiter);
                buffer.append(iter.next().toString());
            }
        }
        return buffer.toString();
    }

    public static String join(Object[] items, String delimiter) {
        return Util.join(Arrays.asList(items), delimiter);
    }

    public static IStatus newErrorStatus(String message) {
        return new Status(4, "com.gwtplugins.gwt.eclipse.core", message);
    }

    public static IStatus newErrorStatus(String message, Object ... args) {
        return Util.newErrorStatus(MessageFormat.format(message, args));
    }

    public static IStatus newWarningStatus(String message) {
        return new Status(2, "com.gwtplugins.gwt.eclipse.core", message);
    }

    public static String removeFileExtension(String filename) {
        return Util.removeFileExtension((IPath)new Path(filename)).toString();
    }

    public static void resetDefaultEditor(String extension) {
        IFileEditorMapping[] editorMappings;
        EditorRegistry editorRegistry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
        IFileEditorMapping[] iFileEditorMappingArray = editorMappings = editorRegistry.getFileEditorMappings();
        int n = editorMappings.length;
        int n2 = 0;
        while (n2 < n) {
            IFileEditorMapping editorMapping = iFileEditorMappingArray[n2];
            if (extension.equals(editorMapping.getExtension())) {
                FileEditorMapping internalMapping = (FileEditorMapping)editorMapping;
                if (internalMapping.getDeclaredDefaultEditors().length <= 0) break;
                ArrayList list = new ArrayList();
                internalMapping.setDefaultEditors(list);
                editorRegistry.saveAssociations();
                GWTPluginLog.logInfo("Reset default editor for extension: " + extension);
                break;
            }
            ++n2;
        }
    }

    public static IStatus validatePackageName(String packageName) {
        if (packageName.length() > 0) {
            String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
            String compliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
            return JavaConventions.validatePackageName((String)packageName, (String)sourceLevel, (String)compliance);
        }
        return Util.newWarningStatus(NewWizardMessages.NewTypeWizardPage_warning_DefaultPackageDiscouraged);
    }

    private static IPath removeFileExtension(IPath path) {
        Path ret = new Path(path.toString());
        while (ret.getFileExtension() != null) {
            ret = ret.removeFileExtension();
        }
        return ret;
    }

    private Util() {
    }
}

