/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators;

import com.google.gdt.eclipse.core.JavaProjectUtilities;
import com.google.gdt.eclipse.core.MarkerUtilities;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gdt.eclipse.core.validators.AbstractProjectValidator;
import com.google.gwt.eclipse.core.runtime.GWTProjectsRuntime;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GWTProjectValidator
extends AbstractProjectValidator {
    private static final String MIN_SDK_VERSION = "2.0.0";
    public static final String BUILDER_ID = "com.gwtplugins.gwt.eclipse.core.gwtProjectValidator";
    public static final String GWT_SDK_TYPE_NAME = "GWT";
    public static final String PROBLEM_MARKER_ID = "com.gwtplugins.gwt.eclipse.core.gwtProjectProblemMarker";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        MarkerUtilities.clearMarkers((String)PROBLEM_MARKER_ID, (IProject)this.getProject());
        if (kind == 15) {
            this.cleanImpl();
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        if (!JavaProjectUtilities.isJavaProjectNonNullAndExists((IJavaProject)javaProject)) {
            return null;
        }
        GwtSdk sdk = GwtSdk.findSdkFor(javaProject);
        if (!GWTProjectsRuntime.isGWTRuntimeProject(javaProject)) {
            if (!this.validateSdk((Sdk)sdk)) {
                return null;
            }
            assert (sdk != null);
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.cleanImpl();
    }

    protected void doAddInvalidSdkMarker(IJavaProject javaProject, Sdk sdk, String detailedErrorMessage) throws CoreException {
        GWTProjectValidator.addInvalidSdkMarker((String)PROBLEM_MARKER_ID, (IJavaProject)javaProject, (Sdk)sdk, (String)GWT_SDK_TYPE_NAME, (String)detailedErrorMessage);
    }

    protected void doAddMissingSdkLibraryMarker(IResource closestEnclosingResourceToWebInfLib, File webAppClasspathFile) throws CoreException {
        GWTProjectValidator.addMissingSdkLibraryMarker((String)PROBLEM_MARKER_ID, (String)GWT_SDK_TYPE_NAME, (IResource)closestEnclosingResourceToWebInfLib, (File)webAppClasspathFile);
    }

    protected void doAddNoSdkMarker(IJavaProject javaProject) throws CoreException {
        GWTProjectValidator.addNoSdkMarker((String)PROBLEM_MARKER_ID, (IJavaProject)javaProject, (String)GWT_SDK_TYPE_NAME);
    }

    protected void doAddSdkFileSizeMismatchMarker(File webAppClasspathFile, IFile webInfLibFile) throws CoreException {
        GWTProjectValidator.addSdkFileSizeMismatchMarker((String)PROBLEM_MARKER_ID, (String)GWT_SDK_TYPE_NAME, (File)webAppClasspathFile, (IFile)webInfLibFile);
    }

    protected String getSupportedSdkVersion() {
        return MIN_SDK_VERSION;
    }

    private void cleanImpl() throws CoreException {
        MarkerUtilities.clearMarkers((String)PROBLEM_MARKER_ID, (IProject)this.getProject());
    }
}

